/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.notifications.api.medium;

import com.atlassian.plugin.notifications.api.event.NotificationEvent;
import com.atlassian.plugin.notifications.api.medium.NotificationAddress;
import com.atlassian.plugin.notifications.api.medium.RenderContextFactory;
import com.atlassian.plugin.notifications.api.medium.ServerConfiguration;
import com.atlassian.plugin.notifications.api.medium.recipient.RoleRecipient;
import com.atlassian.plugin.notifications.api.medium.recipient.UserKeyRoleRecipient;
import com.atlassian.plugin.util.ClassUtils;
import io.atlassian.fugue.Either;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public abstract class RenderContextFactoryTemplate<NE extends NotificationEvent>
implements RenderContextFactory<NE> {
    private final Class<NE> consumesType;

    protected RenderContextFactoryTemplate() {
        this.consumesType = (Class)ClassUtils.getTypeArguments(RenderContextFactoryTemplate.class, this.getClass()).get(0);
        if (this.consumesType == null) {
            throw new IllegalArgumentException(String.format("Expected class [%s] to be parametrized with a specific [%s] type. Use the overloaded constructor if the type is provided at runtime.", this.getClass().getName(), NotificationEvent.class.getName()));
        }
    }

    protected RenderContextFactoryTemplate(Class<NE> consumesType) {
        this.consumesType = consumesType;
    }

    @Override
    public final Class<NE> consumes() {
        return this.consumesType;
    }

    @Override
    public final Map<String, Object> create(NE event, ServerConfiguration serverConfiguration) {
        return this.create(event, serverConfiguration, (Either<NotificationAddress, RoleRecipient>)Either.right((Object)UserKeyRoleRecipient.UNKNOWN));
    }

    @Override
    public final Map<String, Object> create(NE event, ServerConfiguration serverConfiguration, Either<NotificationAddress, RoleRecipient> recipientData) {
        this.performChecks(event, serverConfiguration);
        return this.createChecked((NotificationEvent)event, serverConfiguration, recipientData);
    }

    @Override
    public final Optional<Map<String, Object>> createContext(NE event, ServerConfiguration serverConfig, Either<NotificationAddress, RoleRecipient> recipientData) throws IllegalArgumentException {
        this.performChecks(event, serverConfig);
        return this.createContextChecked(event, serverConfig, recipientData);
    }

    private void performChecks(NE event, ServerConfiguration serverConfiguration) {
        Objects.requireNonNull(event, "The given event is null.");
        Objects.requireNonNull(serverConfiguration, "The given serverConfiguration is null.");
        if (!this.consumesType.isInstance(event)) {
            throw new IllegalArgumentException(String.format("The given event of type [%s] is not assignable to type [%s].", event.getClass().getName(), this.consumesType.getName()));
        }
    }

    protected Map<String, Object> createChecked(NotificationEvent event, ServerConfiguration serverConfiguration, Either<NotificationAddress, RoleRecipient> recipientData) {
        return Collections.emptyMap();
    }

    protected Optional<Map<String, Object>> createContextChecked(NE event, ServerConfiguration serverConfiguration, Either<NotificationAddress, RoleRecipient> recipientData) {
        return Optional.of(this.createChecked((NotificationEvent)event, serverConfiguration, recipientData));
    }
}

