/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.notifications.api.notification;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FilterConfiguration {
    @JsonIgnore
    final Map<String, String> paramMap = new HashMap<String, String>();

    @JsonCreator
    public FilterConfiguration(@JsonProperty(value="params") List<FilterParam> params) {
        for (FilterParam param : params) {
            this.paramMap.put(param.getName(), param.getValue());
        }
    }

    public String get(String key) {
        return this.paramMap.get(key);
    }

    @JsonProperty(value="params")
    public List<FilterParam> getParameterList() {
        ArrayList<FilterParam> ret = new ArrayList<FilterParam>();
        for (Map.Entry<String, String> entry : this.paramMap.entrySet()) {
            ret.add(new FilterParam(entry.getKey(), entry.getValue()));
        }
        return ret;
    }

    public Map<String, String> getParams() {
        return Collections.unmodifiableMap(this.paramMap);
    }

    public static class FilterParam {
        @JsonProperty
        private final String name;
        @JsonProperty
        private final String value;

        @JsonCreator
        public FilterParam(@JsonProperty(value="name") String name, @JsonProperty(value="value") String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

