/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.notifications.config;

import com.atlassian.plugin.notifications.api.medium.ServerConfiguration;
import com.atlassian.plugin.notifications.config.ServerConfigurationManager;
import com.atlassian.plugin.notifications.config.UserServerManager;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import java.util.Collections;
import java.util.Set;
import java.util.stream.StreamSupport;

public class UserServerManagerImpl
implements UserServerManager {
    private static final String SERVER_VISITED_PREFIX = "notifications.server.visited.";
    private final ServerConfigurationManager serverConfigManager;
    private final UserManager userManager;
    private final PluginSettingsFactory pluginSettingsFactory;

    public UserServerManagerImpl(ServerConfigurationManager serverConfigManager, UserManager userManager, PluginSettingsFactory pluginSettingsFactory) {
        this.serverConfigManager = serverConfigManager;
        this.userManager = userManager;
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    @Override
    public boolean hasNewServers(UserKey remoteUser) {
        if (remoteUser == null) {
            return false;
        }
        Iterable<ServerConfiguration> serversForIndividual = this.getServers(remoteUser);
        PluginSettings preferences = this.pluginSettingsFactory.createGlobalSettings();
        boolean newServerAvailable = false;
        for (ServerConfiguration serverConfiguration : serversForIndividual) {
            String propertykey;
            boolean visited;
            if (!serverConfiguration.isConfigurable() || (visited = Boolean.parseBoolean((String)preferences.get(propertykey = this.getServerKey(remoteUser, serverConfiguration.getId()))))) continue;
            newServerAvailable = true;
            break;
        }
        return newServerAvailable;
    }

    @Override
    public void setVisited(UserKey remoteUser, Set<Integer> serverIds) {
        if (remoteUser == null) {
            return;
        }
        PluginSettings preferences = this.pluginSettingsFactory.createGlobalSettings();
        for (Integer serverId : serverIds) {
            String propertyKey = this.getServerKey(remoteUser, serverId);
            preferences.put(propertyKey, (Object)Boolean.TRUE.toString());
        }
    }

    @Override
    public Iterable<ServerConfiguration> getServers(UserKey remoteUser) {
        if (remoteUser == null) {
            return Collections.emptySet();
        }
        return StreamSupport.stream(this.serverConfigManager.getServersForIndividual().spliterator(), false).filter(server -> {
            if (server == null) {
                return false;
            }
            Iterable<String> groupsWithAccess = server.getGroupsWithAccess();
            boolean hasAnyGroups = StreamSupport.stream(groupsWithAccess.spliterator(), false).anyMatch(s -> true);
            if (!hasAnyGroups) {
                return true;
            }
            boolean userInAnyPermittedGroup = StreamSupport.stream(groupsWithAccess.spliterator(), false).anyMatch(groupWithAccess -> groupWithAccess != null && this.userManager.isUserInGroup(remoteUser, groupWithAccess));
            return userInAnyPermittedGroup;
        }).toList();
    }

    private String getServerKey(UserKey remoteUser, int serverId) {
        return SERVER_VISITED_PREFIX + remoteUser.getStringValue() + "." + Integer.toString(serverId);
    }
}

