/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.notifications.dispatcher;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.notifications.api.NotificationHandler;
import com.atlassian.plugin.util.validation.ValidationException;
import java.util.Collections;
import javax.annotation.Nonnull;

public class NotificationHandlerModuleDescriptor
extends AbstractModuleDescriptor<NotificationHandler> {
    private String notificationClass;

    public NotificationHandlerModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    protected void validate(Element element) {
        super.validate(element);
        if (element.attributeValue("class") == null) {
            throw new ValidationException("There were validation errors:", Collections.singletonList("The notification handler class is required"));
        }
        if (element.attributeValue("notification") == null) {
            throw new ValidationException("There were validation errors:", Collections.singletonList("The notification class is required"));
        }
    }

    public void init(@Nonnull Plugin plugin, @Nonnull Element element) throws PluginParseException {
        super.init(plugin, element);
        this.notificationClass = element.attributeValue("notification", "");
    }

    public NotificationHandler getModule() {
        return (NotificationHandler)this.moduleFactory.createModule(this.moduleClassName, (ModuleDescriptor)this);
    }

    public String getNotificationClass() {
        return this.notificationClass;
    }
}

