/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.notifications.dispatcher;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.notifications.api.NotificationHandler;
import com.atlassian.plugin.notifications.api.queue.NotificationQueueManager;
import com.atlassian.plugin.notifications.dispatcher.NotificationHandlerModuleDescriptor;
import com.atlassian.plugin.notifications.dispatcher.util.MatchingHandlerPredicate;
import com.atlassian.plugin.tracker.DefaultPluginModuleTracker;
import com.atlassian.plugin.tracker.PluginModuleTracker;
import java.util.stream.StreamSupport;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class NotificationsEventListener
implements InitializingBean,
DisposableBean {
    private final EventPublisher eventPublisher;
    private final NotificationQueueManager notificationQueueManager;
    private PluginModuleTracker<NotificationHandler, NotificationHandlerModuleDescriptor> handlerTracker;

    public NotificationsEventListener(EventPublisher eventPublisher, PluginAccessor pluginAccessor, PluginEventManager pluginEventManager, NotificationQueueManager notificationQueueManager) {
        this.eventPublisher = eventPublisher;
        this.notificationQueueManager = notificationQueueManager;
        this.handlerTracker = DefaultPluginModuleTracker.create((PluginAccessor)pluginAccessor, (PluginEventManager)pluginEventManager, NotificationHandlerModuleDescriptor.class);
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void handleEvent(Object event) {
        Iterable handlers = this.handlerTracker.getModuleDescriptors();
        boolean matchingHandlers = StreamSupport.stream(handlers.spliterator(), false).anyMatch(new MatchingHandlerPredicate(event));
        if (matchingHandlers) {
            this.notificationQueueManager.processEvent(event);
        }
    }
}

