/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.notifications.dispatcher.task;

import com.atlassian.plugin.notifications.api.NotificationHandler;
import com.atlassian.plugin.notifications.dispatcher.NotificationHandlerModuleDescriptor;
import com.atlassian.plugin.notifications.dispatcher.TaskComponents;
import com.atlassian.plugin.notifications.dispatcher.util.MatchingHandlerPredicate;
import com.atlassian.plugin.tracker.PluginModuleTracker;
import java.util.List;
import java.util.stream.StreamSupport;

public class NotificationTaskProducer
implements Runnable {
    private final TaskComponents components;
    private final Object event;

    public NotificationTaskProducer(TaskComponents components, Object event) {
        this.components = components;
        this.event = event;
    }

    @Override
    public void run() {
        PluginModuleTracker<NotificationHandler, NotificationHandlerModuleDescriptor> handlerTracker = this.components.getHandlerTracker();
        List<NotificationHandlerModuleDescriptor> handlers = StreamSupport.stream(handlerTracker.getModuleDescriptors().spliterator(), false).filter(new MatchingHandlerPredicate(this.event)).toList();
        for (NotificationHandlerModuleDescriptor handler : handlers) {
            NotificationHandler module = handler.getModule();
            if (module == null) continue;
            try {
                module.handle(this.event);
            }
            catch (RuntimeException e) {
                this.components.getErrorRegistry().getLogger().error((Object)("Error producing notification task with handler '" + handler.getCompleteKey() + "'."), (Throwable)e);
            }
        }
    }
}

