/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.notifications.module;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.notifications.api.TextUtil;
import com.atlassian.plugin.notifications.api.macros.Macro;
import com.atlassian.plugin.notifications.api.macros.MacroResolver;
import com.atlassian.plugin.notifications.module.macros.NotificationMacroModuleDescriptor;
import com.atlassian.plugin.tracker.DefaultPluginModuleTracker;
import com.atlassian.plugin.tracker.PluginModuleTracker;
import java.util.Map;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.apache.log4j.Logger;

public class DefaultMacroResolver
implements MacroResolver,
TextUtil.MacroKeyReplacer {
    private static final Logger log = Logger.getLogger(DefaultMacroResolver.class);
    private final PluginModuleTracker<Macro, NotificationMacroModuleDescriptor> macroTracker;

    public DefaultMacroResolver(PluginAccessor pluginAccessor, PluginEventManager pluginEventManager) {
        this.macroTracker = DefaultPluginModuleTracker.create((PluginAccessor)pluginAccessor, (PluginEventManager)pluginEventManager, NotificationMacroModuleDescriptor.class);
    }

    @Override
    public String resolveAll(String text, Map<String, Object> context) {
        return TextUtil.replaceMacroKeys(text, context, this);
    }

    @Override
    public String replace(String macroKey, Map<String, Object> context) {
        Optional<Macro> macro = StreamSupport.stream(this.macroTracker.getModules().spliterator(), false).filter(input -> input != null && input.getName().equals(macroKey)).findAny();
        if (macro.isEmpty()) {
            return macroKey;
        }
        try {
            return macro.get().resolve(context);
        }
        catch (RuntimeException e) {
            log.error((Object)("Could not load macro with key '" + macroKey + "'"));
            return macroKey;
        }
    }
}

