/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.notifications.module;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.notifications.api.medium.NotificationMedium;
import com.atlassian.plugin.notifications.module.NotificationMediumManager;
import com.atlassian.plugin.notifications.module.NotificationMediumModuleDescriptor;
import com.atlassian.plugin.tracker.DefaultPluginModuleTracker;
import com.atlassian.plugin.tracker.PluginModuleTracker;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.stream.StreamSupport;

public class DefaultNotificationMediumManager
implements NotificationMediumManager {
    private final PluginModuleTracker<NotificationMedium, NotificationMediumModuleDescriptor> mediumTracker;

    public DefaultNotificationMediumManager(PluginAccessor pluginAccessor, PluginEventManager pluginEventManager) {
        this.mediumTracker = DefaultPluginModuleTracker.create((PluginAccessor)pluginAccessor, (PluginEventManager)pluginEventManager, NotificationMediumModuleDescriptor.class);
    }

    @Override
    public NotificationMedium getNotificationMedium(String key) {
        return StreamSupport.stream(this.mediumTracker.getModules().spliterator(), false).filter(notificationMedium -> notificationMedium != null && notificationMedium.getKey().equals(key)).findAny().orElse(null);
    }

    @Override
    public NotificationMediumModuleDescriptor getNotificationMediumModuleDescriptor(String key) {
        Iterable moduleDescriptors = this.mediumTracker.getModuleDescriptors();
        return StreamSupport.stream(moduleDescriptors.spliterator(), false).filter(input -> input != null && input.getKey().equals(key)).findAny().orElse(null);
    }

    @Override
    public String getI18nizedMediumName(I18nResolver i18n, String key) {
        NotificationMediumModuleDescriptor descriptor = this.getNotificationMediumModuleDescriptor(key);
        if (descriptor == null) {
            return key;
        }
        if (descriptor.getI18nNameKey() != null) {
            return i18n.getText(descriptor.getI18nNameKey());
        }
        if (descriptor.getName() != null) {
            return descriptor.getName();
        }
        return key;
    }

    @Override
    public Set<NotificationMedium> getNotificationMediums() {
        return Sets.newLinkedHashSet((Iterable)this.mediumTracker.getModules());
    }
}

