/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.notifications.rest;

import com.atlassian.plugin.notifications.api.ErrorCollection;
import com.atlassian.plugin.notifications.api.HandleErrorFunction;
import com.atlassian.plugin.notifications.api.notification.NotificationRepresentation;
import com.atlassian.plugin.notifications.api.notification.NotificationSchemeRepresentation;
import com.atlassian.plugin.notifications.api.notification.NotificationSchemeService;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import io.atlassian.fugue.Either;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.function.Function;
import javax.annotation.Nullable;

@Path(value="scheme")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@WebSudoRequired
public class NotificationSchemeResource {
    private final UserManager userManager;
    private final NotificationSchemeService notificationService;

    @Inject
    public NotificationSchemeResource(UserManager userManager, NotificationSchemeService notificationService) {
        this.userManager = userManager;
        this.notificationService = notificationService;
    }

    @GET
    public Response getDefaultScheme(@Context UriInfo uriInfo) {
        return this.getScheme(uriInfo);
    }

    @GET
    @Path(value="{schemeId}")
    public Response getScheme(@Context UriInfo uriInfo) {
        Either<ErrorCollection, NotificationSchemeRepresentation> result = this.notificationService.scheme(this.userManager.getRemoteUsername());
        return (Response)result.fold((Function)new HandleErrorFunction(), (Function)new Function<NotificationSchemeRepresentation, Response>(this){

            @Override
            public Response apply(@Nullable NotificationSchemeRepresentation input) {
                return Response.ok((Object)input).cacheControl(HandleErrorFunction.NO_CACHE).build();
            }
        });
    }

    @POST
    @Path(value="{schemeId}/notification")
    public Response createNotification(@Context UriInfo uriInfo, @PathParam(value="schemeId") int schemeId, NotificationRepresentation notification) {
        Either<ErrorCollection, NotificationRepresentation> result = this.notificationService.validateAdd(this.userManager.getRemoteUsername(), notification);
        return (Response)result.fold((Function)new HandleErrorFunction(), (Function)new Function<NotificationRepresentation, Response>(){

            @Override
            public Response apply(@Nullable NotificationRepresentation input) {
                NotificationRepresentation newNotification = NotificationSchemeResource.this.notificationService.addNotification(NotificationSchemeResource.this.userManager.getRemoteUsername(), input);
                return Response.ok((Object)newNotification).cacheControl(HandleErrorFunction.NO_CACHE).build();
            }
        });
    }

    @GET
    @Path(value="{schemeId}/notification/{notificationId}")
    public Response getNotification(@Context UriInfo uriInfo, @PathParam(value="schemeId") int schemeId, @PathParam(value="notificationId") int notificationId) {
        Either<ErrorCollection, NotificationRepresentation> result = this.notificationService.schemeNotification(this.userManager.getRemoteUsername(), notificationId);
        return (Response)result.fold((Function)new HandleErrorFunction(), (Function)new Function<NotificationRepresentation, Response>(this){

            @Override
            public Response apply(@Nullable NotificationRepresentation input) {
                return Response.ok((Object)input).cacheControl(HandleErrorFunction.NO_CACHE).build();
            }
        });
    }

    @PUT
    @Path(value="{schemeId}/notification/{notificationId}")
    public Response updateNotification(@Context UriInfo uriInfo, @PathParam(value="schemeId") int schemeId, final @PathParam(value="notificationId") int notificationId, NotificationRepresentation notification) {
        Either<ErrorCollection, NotificationRepresentation> result = this.notificationService.validateUpdate(this.userManager.getRemoteUsername(), notificationId, notification);
        return (Response)result.fold((Function)new HandleErrorFunction(), (Function)new Function<NotificationRepresentation, Response>(){

            @Override
            public Response apply(@Nullable NotificationRepresentation input) {
                NotificationRepresentation newNotification = NotificationSchemeResource.this.notificationService.updateNotification(NotificationSchemeResource.this.userManager.getRemoteUsername(), notificationId, input);
                return Response.ok((Object)newNotification).cacheControl(HandleErrorFunction.NO_CACHE).build();
            }
        });
    }

    @DELETE
    @Path(value="{schemeId}/notification/{notificationId}")
    public Response removeNotification(@PathParam(value="schemeId") int schemeId, @PathParam(value="notificationId") int notificationId) {
        ErrorCollection errors = this.notificationService.validateRemoveNotification(this.userManager.getRemoteUsername(), notificationId);
        if (errors.hasAnyErrors()) {
            return new HandleErrorFunction().apply(errors);
        }
        this.notificationService.removeNotification(notificationId);
        return Response.ok().cacheControl(HandleErrorFunction.NO_CACHE).build();
    }
}

