/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.notifications.ui;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.plugin.notifications.api.medium.ServerConfiguration;
import com.atlassian.plugin.notifications.api.notification.UserNotificationPreferencesManager;
import com.atlassian.plugin.notifications.config.UserServerManager;
import com.atlassian.plugin.notifications.spi.UserRolesProvider;
import com.atlassian.plugin.web.api.DynamicWebInterfaceManager;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.webresource.api.WebResourceManager;
import com.google.common.collect.Maps;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.beans.factory.annotation.Qualifier;

@LicensedOnly
public class UserSettingsServlet
extends HttpServlet {
    private final TemplateRenderer renderer;
    private final UserManager userManager;
    private final LoginUriProvider loginUriProvider;
    private final WebResourceManager webResourceManager;
    private final UserNotificationPreferencesManager prefManager;
    private final UserServerManager userServerManager;
    private final I18nResolver i18n;
    private final UserRolesProvider rolesProvider;
    private final DynamicWebInterfaceManager webInterfaceManager;

    public UserSettingsServlet(TemplateRenderer renderer, UserManager userManager, LoginUriProvider loginUriProvider, WebResourceManager webResourceManager, UserNotificationPreferencesManager prefManager, UserServerManager userServerManager, @Qualifier(value="i18nResolver") I18nResolver i18n, UserRolesProvider rolesProvider, DynamicWebInterfaceManager webInterfaceManager) {
        this.renderer = renderer;
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.webResourceManager = webResourceManager;
        this.prefManager = prefManager;
        this.userServerManager = userServerManager;
        this.i18n = i18n;
        this.rolesProvider = rolesProvider;
        this.webInterfaceManager = webInterfaceManager;
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html");
        UserKey remoteUserKey = this.userManager.getRemoteUserKey(request);
        if (remoteUserKey == null) {
            response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
            return;
        }
        this.webResourceManager.requireResource("com.atlassian.plugin.notifications.notifications-module:notification-prefs");
        HashMap<String, Object> params = new HashMap<String, Object>();
        Map<String, Object> webPanelContext = this.makeWebPanelContext(remoteUserKey);
        List<ServerConfiguration> servers = StreamSupport.stream(this.userServerManager.getServers(remoteUserKey).spliterator(), false).toList();
        webPanelContext.put("servers", servers);
        params.put("webPanelContext", webPanelContext);
        params.put("servers", servers);
        params.put("i18n", this.i18n);
        params.put("webInterfaceManager", this.webInterfaceManager);
        Set<Integer> serverIdsVisited = servers.stream().map(ServerConfiguration::getId).collect(Collectors.toSet());
        this.userServerManager.setVisited(remoteUserKey, serverIdsVisited);
        this.renderer.render("templates/usersettings.vm", params, (Writer)response.getWriter());
    }

    private Map<String, Object> makeWebPanelContext(UserKey remoteUserKey) {
        HashMap params = Maps.newHashMap();
        params.put("i18n", this.i18n);
        params.put("profileUser", this.userManager.getUserProfile(remoteUserKey));
        params.put("userRoles", this.rolesProvider.getRoles());
        params.put("userPrefs", this.prefManager.getPreferences(remoteUserKey));
        return params;
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }
}

