/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.gatekeeper.controllers;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.plugins.gatekeeper.license.AddonLicenseManager;
import com.atlassian.confluence.plugins.gatekeeper.service.AddonGlobal;
import com.atlassian.confluence.plugins.gatekeeper.service.Configuration;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.plugin.osgi.bridge.external.PluginRetrievalService;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

@AdminOnly
public class ConfigurationAction
extends ConfluenceActionSupport {
    private boolean licensed;
    private String pluginKey;
    private AddonGlobal addonGlobal;
    private AddonLicenseManager licenseManager;
    private PluginSettingsFactory pluginSettingsFactory;
    private TransactionTemplate transactionTemplate;
    private boolean allowWhoCanViewButton = false;

    public boolean isPermitted() {
        return this.permissionManager.hasPermission(this.getAuthenticatedUser(), Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }

    @PermittedMethods(value={HttpMethod.GET})
    public String showConfiguration() {
        this.checkLicense();
        Configuration configuration = new Configuration(this.pluginSettingsFactory, this.licenseManager);
        this.allowWhoCanViewButton = configuration.isWhoCanViewButtonAllowed();
        return "success";
    }

    public String saveConfiguration() {
        this.checkLicense();
        Configuration configuration = new Configuration(this.pluginSettingsFactory, this.licenseManager);
        configuration.setWhoCanViewButtonAllowed(this.allowWhoCanViewButton);
        return "success";
    }

    protected boolean checkLicense() {
        this.licensed = this.licenseManager.getLicenseInfo().isValid() && this.licenseManager.getLicenseInfo().isDCFeatureLicensed();
        return this.licensed;
    }

    public void setPluginSettingsFactory(PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    public void setPluginRetrievalService(PluginRetrievalService pluginRetrievalService) {
        this.pluginKey = pluginRetrievalService.getPlugin().getKey();
    }

    public void setAddonGlobal(AddonGlobal addonGlobal) {
        this.addonGlobal = addonGlobal;
    }

    public void setLicenseManager(AddonLicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public boolean isLicensed() {
        return this.licensed;
    }

    public String getPluginKey() {
        return this.pluginKey;
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public boolean isAllowWhoCanViewButton() {
        return this.allowWhoCanViewButton;
    }

    @StrutsParameter
    public void setAllowWhoCanViewButton(boolean allowWhoCanViewButton) {
        this.allowWhoCanViewButton = allowWhoCanViewButton;
    }
}

