/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.gatekeeper.evaluator.cache;

import com.atlassian.confluence.persistence.JpaQueryFactory;
import jakarta.persistence.Query;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryByIdBatcher {
    private static final Logger logger = LoggerFactory.getLogger(QueryByIdBatcher.class);
    private static final int DEFAULT_BATCH_SIZE = Integer.getInteger("gatekeeper.query.batch.size", 1000);
    private final int batchSize;
    private final JpaQueryFactory entityManager;
    private final Function<JpaQueryFactory, Query> queryStart;
    private final Function<JpaQueryFactory, Query> queryBatched;
    private Long startingId = null;
    private final HashMap<String, Object> extraParameters = new HashMap();

    public QueryByIdBatcher(JpaQueryFactory entityManager, Function<JpaQueryFactory, Query> queryStart, Function<JpaQueryFactory, Query> queryBatched) {
        this(entityManager, queryStart, queryBatched, DEFAULT_BATCH_SIZE);
    }

    public QueryByIdBatcher(JpaQueryFactory entityManager, Function<JpaQueryFactory, Query> queryStart, Function<JpaQueryFactory, Query> queryBatched, int batchSize) {
        this.entityManager = entityManager;
        this.queryStart = queryStart;
        this.queryBatched = queryBatched;
        this.batchSize = batchSize;
    }

    public List<Object[]> getBatch() {
        Query query;
        if (this.startingId != null) {
            query = this.queryBatched.apply(this.entityManager);
            query.setParameter("id", (Object)this.startingId);
        } else {
            query = this.queryStart.apply(this.entityManager);
        }
        if (!this.extraParameters.isEmpty()) {
            for (String fieldName : this.extraParameters.keySet()) {
                query.setParameter(fieldName, this.extraParameters.get(fieldName));
            }
        }
        query.setMaxResults(this.batchSize);
        List<Object[]> queryResults = new ArrayList();
        try {
            queryResults = query.getResultList();
        }
        catch (RuntimeException e) {
            logger.error("Loading from database failed.", (Throwable)e);
        }
        if (!queryResults.isEmpty()) {
            this.startingId = (Long)queryResults.get(queryResults.size() - 1)[0];
        }
        return queryResults;
    }

    public void addQueryParameter(String fieldName, Object fieldValue) {
        this.extraParameters.put(fieldName, fieldValue);
    }

    public long getStartingId() {
        return this.startingId;
    }

    public int getBatchSize() {
        return this.batchSize;
    }
}

