/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.gatekeeper.evaluator.cache;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.persistence.JpaQueryFactory;
import com.atlassian.confluence.plugins.gatekeeper.evaluator.cache.QueryByIdBatcher;
import com.atlassian.confluence.plugins.gatekeeper.evaluator.cache.SubCache;
import com.atlassian.confluence.plugins.gatekeeper.model.comparator.SpaceComparator;
import com.atlassian.confluence.plugins.gatekeeper.model.event.TinyEvent;
import com.atlassian.confluence.plugins.gatekeeper.model.event.TinySpaceEvent;
import com.atlassian.confluence.plugins.gatekeeper.model.space.TinySpace;
import com.atlassian.confluence.plugins.gatekeeper.util.CopyOnceMap;
import com.atlassian.confluence.spaces.SpaceStatus;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import jakarta.persistence.Query;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SpaceCache
implements SubCache {
    private static final Logger logger = LoggerFactory.getLogger(SpaceCache.class);
    private static final Function<JpaQueryFactory, Query> SPACE_TABLE_QUERY_INITIAL = em -> em.createQuery("SELECT id, key, name, spaceStatus FROM Space ORDER BY id");
    private static final Function<JpaQueryFactory, Query> SPACE_TABLE_QUERY_BATCHED = em -> em.createQuery("SELECT id, key, name, spaceStatus FROM Space WHERE id > :id ORDER BY id");
    private Set<TinySpace> spaces;
    private Map<String, TinySpace> spaceMap;
    private CopyOnceMap<TinySpace> updateMap;

    SpaceCache(Map<String, TinySpace> spaceMap) {
        this.spaceMap = spaceMap;
        this.updateMap = new CopyOnceMap<TinySpace>(spaceMap);
    }

    SpaceCache(SpaceCache spaceCache) {
        this(spaceCache.spaceMap);
        this.spaces = spaceCache.spaces;
    }

    SpaceCache(JpaQueryFactory entityManager) {
        this.spaceMap = new Object2ObjectOpenHashMap();
        logger.trace("Reading space info: started");
        this.initializeCacheInBatchQueries(entityManager);
    }

    private void initializeCacheInBatchQueries(JpaQueryFactory entityManager) {
        List<Object[]> queryResults;
        int counter = 0;
        QueryByIdBatcher queryByIdBatcher = new QueryByIdBatcher(entityManager, SPACE_TABLE_QUERY_INITIAL, SPACE_TABLE_QUERY_BATCHED);
        while (!(queryResults = queryByIdBatcher.getBatch()).isEmpty()) {
            for (Object[] row : queryResults) {
                String key = (String)row[1];
                String name = (String)row[2];
                SpaceStatus spaceStatus = (SpaceStatus)row[3];
                this.spaceMap.put(key, new TinySpace(key, name, spaceStatus == SpaceStatus.CURRENT));
                logger.trace("Reading space info: processing space {}", (Object)key);
                ++counter;
            }
            logger.trace("Finished reading one batch - Reading space info: processed {} spaces", (Object)counter);
            if (queryResults.size() >= queryByIdBatcher.getBatchSize()) continue;
        }
        this.updateMap = new CopyOnceMap<TinySpace>(this.spaceMap);
        logger.trace("Reading space info: processed {} spaces", (Object)counter);
    }

    @Override
    @VisibleForTesting
    public void update(TinyEvent event) {
        if (!(event instanceof TinySpaceEvent)) {
            logger.debug("The event is not a TinySpaceEvent. Event type is {}", (Object)event.getEventType().name());
            return;
        }
        TinySpaceEvent tinySpaceEvent = (TinySpaceEvent)event;
        String spaceKey = tinySpaceEvent.getKey();
        switch (event.getEventType()) {
            case SPACE_ADDED: 
            case SPACE_UPDATED: {
                TinySpace space = this.updateMap.getOrCopy(spaceKey);
                if (space == null) {
                    logger.debug("No space with key {} found in the cache. Recreating the space object...", (Object)spaceKey);
                    space = new TinySpace(spaceKey, tinySpaceEvent.getName(), true);
                }
                this.updateMap.put(spaceKey, space);
                space.setName(tinySpaceEvent.getName());
                break;
            }
            case SPACE_DELETED: {
                this.updateMap.remove(spaceKey);
                break;
            }
            case SPACE_ARCHIVED: {
                TinySpace space = this.updateMap.getOrCopy(spaceKey);
                if (space != null) {
                    space.setCurrent(false);
                    break;
                }
                logger.debug("No space with key {} found in the cache.", (Object)spaceKey);
                break;
            }
            case SPACE_UNARCHIVED: {
                TinySpace space = this.updateMap.getOrCopy(spaceKey);
                if (space != null) {
                    space.setCurrent(true);
                    break;
                }
                logger.debug("No space with key {} found in the cache.", (Object)spaceKey);
                break;
            }
        }
    }

    public void finish() {
        if (this.spaces == null || this.updateMap.isModified()) {
            this.spaceMap = this.updateMap.getUnderlyingMap();
            this.spaces = new TreeSet<TinySpace>(SpaceComparator.SPACE_COMPARATOR);
            this.spaces.addAll(this.spaceMap.values());
        }
    }

    public List<TinySpace> getSpaces() {
        if (this.spaces == null) {
            return Collections.emptyList();
        }
        return this.spaces.stream().toList();
    }

    public TinySpace get(String key) {
        return this.spaceMap.get(key);
    }
}

