/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.gatekeeper.service;

import com.atlassian.confluence.plugins.gatekeeper.license.AddonLicenseManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;

public class Configuration {
    private static final String ULTIMATEPERMISSIONS_NAMESPACE = "com.atlassian.confluence.plugins.gatekeeper.confluence.ultimatepermissions";
    private static final String ALLOW_WHO_CAN_VIEW_BUTTON = "allow.who-can-view.button";
    private final AddonLicenseManager addonLicenseManager;
    private final PluginSettings pluginSettings;

    public Configuration(PluginSettingsFactory pluginSettingsFactory, AddonLicenseManager addonLicenseManager) {
        this.addonLicenseManager = addonLicenseManager;
        this.pluginSettings = pluginSettingsFactory.createSettingsForKey(ULTIMATEPERMISSIONS_NAMESPACE);
    }

    public boolean isWhoCanViewButtonAllowed() {
        return AuthenticatedUserThreadLocal.get() != null && this.addonLicenseManager.getLicenseInfo().isValid() && this.isAllowedInConfig();
    }

    private boolean isAllowedInConfig() {
        String allowed = (String)this.pluginSettings.get(ALLOW_WHO_CAN_VIEW_BUTTON);
        return allowed == null || Boolean.parseBoolean(allowed);
    }

    public void setWhoCanViewButtonAllowed(boolean allowed) {
        this.pluginSettings.put(ALLOW_WHO_CAN_VIEW_BUTTON, (Object)Boolean.toString(allowed));
    }
}

