/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.templaterenderer.velocity.one.six.internal;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.templaterenderer.RenderingException;
import com.atlassian.templaterenderer.TemplateContextFactory;
import com.atlassian.templaterenderer.velocity.CompositeClassLoader;
import com.atlassian.templaterenderer.velocity.TemplateRendererAnnotationBoxingUberspect;
import com.atlassian.templaterenderer.velocity.TemplateRendererHtmlAnnotationEscaper;
import com.atlassian.templaterenderer.velocity.one.six.VelocityTemplateRenderer;
import com.atlassian.templaterenderer.velocity.resource.AtlassianClasspathResourceLoader;
import com.atlassian.util.profiling.Metrics;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.velocity.htmlsafe.HtmlSafeDirective;
import com.atlassian.velocity.htmlsafe.directive.DisableHtmlEscaping;
import com.atlassian.velocity.htmlsafe.directive.EnableHtmlEscaping;
import com.atlassian.velocity.htmlsafe.event.referenceinsertion.DisableHtmlEscapingDirectiveHandler;
import com.atlassian.velocity.htmlsafe.introspection.AnnotationBoxingUberspect;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.app.event.EventCartridge;
import org.apache.velocity.app.event.EventHandler;
import org.apache.velocity.app.event.ReferenceInsertionEventHandler;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.log.CommonsLogLogChute;
import org.apache.velocity.util.introspection.UberspectImpl;

public class VelocityTemplateRendererImpl
implements VelocityTemplateRenderer {
    public static final String DEFAULT_ENCODING = "UTF-8";
    private final EventPublisher eventPublisher;
    private final ClassLoader classLoader;
    private final String pluginKey;
    private final TemplateContextFactory templateContextFactory;
    @VisibleForTesting
    final VelocityEngine velocity;

    public VelocityTemplateRendererImpl(ClassLoader classLoader, EventPublisher eventPublisher, String pluginKey, Map<String, String> properties, TemplateContextFactory templateContextFactory) {
        this.classLoader = classLoader;
        this.eventPublisher = eventPublisher;
        this.pluginKey = pluginKey;
        this.templateContextFactory = templateContextFactory;
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        CompositeClassLoader compositeClassLoader = new CompositeClassLoader(new ClassLoader[]{this.getClass().getClassLoader(), AnnotationBoxingUberspect.class.getClassLoader(), classLoader});
        Thread.currentThread().setContextClassLoader((ClassLoader)compositeClassLoader);
        try {
            this.velocity = new VelocityEngine();
            try (InputStream productVelocityPropertiesStream = compositeClassLoader.getResourceAsStream("velocity.properties");){
                if (productVelocityPropertiesStream != null) {
                    ExtendedProperties productVelocityProperties = new ExtendedProperties();
                    productVelocityProperties.load(productVelocityPropertiesStream);
                    this.velocity.setExtendedProperties(productVelocityProperties);
                }
            }
            Object value = this.velocity.getProperty("runtime.introspector.uberspect");
            if (value == null || value.equals(UberspectImpl.class.getName())) {
                this.velocity.setProperty("runtime.introspector.uberspect", (Object)TemplateRendererAnnotationBoxingUberspect.class.getName());
            }
            this.velocity.setProperty("runtime.log.logsystem.class", (Object)CommonsLogLogChute.class.getName());
            this.velocity.setProperty("resource.loader", (Object)"classpath");
            this.velocity.setProperty("classpath.resource.loader.class", (Object)AtlassianClasspathResourceLoader.class.getName());
            this.velocity.setProperty("resource.loader.file.allowlist.enabled", (Object)"false");
            this.velocity.setProperty("resource.loader.filetype.allowlist.enabled", (Object)"false");
            this.velocity.addProperty("userdirective", (Object)EnableHtmlEscaping.class.getName());
            this.velocity.addProperty("userdirective", (Object)DisableHtmlEscaping.class.getName());
            this.velocity.addProperty("userdirective", (Object)HtmlSafeDirective.class.getName());
            for (Map.Entry<String, String> prop : properties.entrySet()) {
                this.velocity.setProperty(prop.getKey(), (Object)prop.getValue());
            }
            this.handleCache();
            this.velocity.clearProperty("velocimacro.library");
            this.velocity.init();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    public void render(String templateName, Writer writer) throws RenderingException, IOException {
        this.render(templateName, Collections.emptyMap(), writer);
    }

    public void render(String templateName, Map<String, Object> context, Writer writer) throws RenderingException, IOException {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        try (Ticker ignored = Metrics.metric((String)"webTemplateRenderer").tag("templateRenderer", "velocity").tag("templateName", templateName).fromPluginKey(this.pluginKey).withAnalytics().startTimer();){
            boolean shouldWriteComments = Boolean.getBoolean("atl.html.trace.comments.velocity-template-renderer.enabled");
            if (shouldWriteComments) {
                writer.write(String.format("<!-- [START] [velocity-template-renderer] plugin-key: %s template: %s -->", this.pluginKey, templateName));
            }
            Template template = this.velocity.getTemplate(templateName, DEFAULT_ENCODING);
            template.merge((Context)this.createContext(context), writer);
            if (shouldWriteComments) {
                writer.write(String.format("<!-- [END] [velocity-template-renderer] plugin-key: %s template: %s -->", this.pluginKey, templateName));
            }
            writer.flush();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RenderingException((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    public String renderFragment(String fragment, Map<String, Object> context) {
        try {
            StringWriter tempWriter = new StringWriter(fragment.length());
            this.velocity.evaluate((Context)this.createContext(context), (Writer)tempWriter, "renderFragment", fragment);
            return tempWriter.toString();
        }
        catch (Exception e) {
            throw new RenderingException((Throwable)e);
        }
    }

    private void handleCache() {
        String IS_DEV_MODE = Boolean.toString(this.isDevMode());
        String IS_PROD_MODE = Boolean.toString(!this.isDevMode());
        this.velocity.setProperty("classpath.resource.loader.cache", (Object)IS_PROD_MODE);
        this.velocity.setProperty("plugin.resource.loader.cache", (Object)IS_PROD_MODE);
        this.velocity.setProperty("velocimacro.library.autoreload", (Object)IS_DEV_MODE);
    }

    private boolean isDevMode() {
        return Boolean.getBoolean("atlassian.dev.mode");
    }

    private VelocityContext createContext(Map<String, Object> contextParams) {
        VelocityContext velocityContext = new VelocityContext(this.templateContextFactory.createContext(this.pluginKey, contextParams));
        velocityContext.attachEventCartridge(this.createCartridgeFrom(List.of(new DisableHtmlEscapingDirectiveHandler((ReferenceInsertionEventHandler)new TemplateRendererHtmlAnnotationEscaper()))));
        return velocityContext;
    }

    private EventCartridge createCartridgeFrom(List<? extends EventHandler> eventHandlers) {
        EventCartridge cartridge = new EventCartridge();
        for (EventHandler eventHandler : eventHandlers) {
            cartridge.addEventHandler(eventHandler);
        }
        return cartridge;
    }

    public boolean resolve(String templateName) {
        return this.classLoader.getResource(templateName) != null;
    }
}

