/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.core.frontend.servlet;

import com.atlassian.annotations.security.SystemAdminOnly;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SystemAdminOnly
public class DataPipelineServlet
extends HttpServlet {
    static final String RESOURCE_KEY = "com.atlassian.business.insights.core-plugin:bi-frontend-base-resources";
    static final String TEMPLATE_KEY_PREFIX = "atlassian.business.insights.";
    static final String ENCODING = StandardCharsets.UTF_8.name();
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final UserManager userManager;
    private final LoginUriProvider loginUriProvider;
    private final WebSudoManager webSudoManager;
    private final Logger logger;

    public DataPipelineServlet(SoyTemplateRenderer soyTemplateRenderer, UserManager userManager, LoginUriProvider loginUriProvider, WebSudoManager webSudoManager) {
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.webSudoManager = webSudoManager;
        this.logger = LoggerFactory.getLogger(DataPipelineServlet.class);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        UserProfile user = this.userManager.getRemoteUser(req);
        if (user == null) {
            this.redirectToLogin(req, res);
            return;
        }
        res.setContentType("text/html;charset=" + ENCODING);
        try {
            this.webSudoManager.willExecuteWebSudoRequest(req);
            if (!this.userManager.isSystemAdmin(user.getUserKey())) {
                this.soyTemplateRenderer.render((Appendable)res.getWriter(), RESOURCE_KEY, "atlassian.business.insights.unauthorised", null);
            } else {
                this.soyTemplateRenderer.render((Appendable)res.getWriter(), RESOURCE_KEY, "atlassian.business.insights.authorised", null);
            }
        }
        catch (SoyException e) {
            this.logger.error(String.format("Error rendering Soy templates: %s; %s", e.toString(), e.getCause()));
            throw new ServletException(String.format("Error rendering Soy templates: %s", new Object[]{e}));
        }
        catch (WebSudoSessionException e) {
            this.webSudoManager.enforceWebSudoProtection(req, res);
        }
    }

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        URI uri = URI.create(request.getRequestURL().toString());
        response.sendRedirect(this.loginUriProvider.getLoginUri(uri).toASCIIString());
    }
}

