/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.core.mapper;

import com.atlassian.business.insights.api.LogRecord;
import com.atlassian.business.insights.api.schema.FileSchema;
import com.atlassian.business.insights.api.schema.Schema;
import com.atlassian.business.insights.core.mapper.FileRecord;
import com.atlassian.business.insights.core.mapper.api.LogRecordMapper;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;

public class DefaultLogRecordMapper<K>
implements LogRecordMapper<K> {
    @Override
    @Nonnull
    public Stream<FileRecord> map(@Nonnull Schema schema, @Nonnull LogRecord<K> logRecord, Set<String> optedOutFileSchemas) {
        Objects.requireNonNull(logRecord);
        return schema.getFileSchemas().stream().filter(FileSchema::isEnabled).filter(fileSchema -> !optedOutFileSchemas.contains(fileSchema.getFileNamePrefix())).map(fileSchema -> FileRecord.getInstance(logRecord.getPayload(), fileSchema)).filter(fileRecord -> !fileRecord.getRows().isEmpty());
    }
}

