/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.core.rest;

import com.atlassian.business.insights.api.dataset.DatasetProvider;
import com.atlassian.business.insights.core.analytics.history.JobHistoryRequestedAnalyticEvent;
import com.atlassian.business.insights.core.rest.model.Page;
import com.atlassian.business.insights.core.rest.model.ProcessStatusResponse;
import com.atlassian.business.insights.core.rest.validation.validators.RequestValidator;
import com.atlassian.business.insights.core.rest.validation.validators.queryparam.PageLimitValidator;
import com.atlassian.business.insights.core.rest.validation.validators.queryparam.PageOffsetValidator;
import com.atlassian.business.insights.core.rest.validation.validators.queryparam.Validator;
import com.atlassian.business.insights.core.service.api.EventPublisherService;
import com.atlassian.business.insights.core.service.api.ExportJobState;
import com.atlassian.business.insights.core.service.api.ExportJobStateService;
import com.atlassian.business.insights.core.util.DateConversionUtil;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import java.util.stream.Collectors;

@OpenAPIDefinition(info=@Info(title="Data Pipeline History Resource", version="1.0.0", description="Experimental Data Pipeline API. Endpoint to query for job history from previous Data Pipeline runs in descending order. The root path is /rest/datapipeline/latest"))
@Path(value="/history")
@SystemAdminOnly
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class HistoryResource {
    private final ExportJobStateService exportJobStateService;
    private final DateConversionUtil dateConversionUtil;
    private final DatasetProvider datasetProvider;
    private final EventPublisherService eventPublisherService;
    private final RequestValidator requestValidator;

    @Inject
    public HistoryResource(ExportJobStateService exportJobStateService, DateConversionUtil dateConversionUtil, DatasetProvider datasetProvider, EventPublisherService eventPublisherService, RequestValidator requestValidator) {
        this.exportJobStateService = exportJobStateService;
        this.dateConversionUtil = dateConversionUtil;
        this.datasetProvider = datasetProvider;
        this.eventPublisherService = eventPublisherService;
        this.requestValidator = requestValidator;
    }

    @GET
    public Response queryHistory(@Parameter(description="The offset from when the history should be queried for") @Schema(type="integer") @QueryParam(value="offset") @DefaultValue(value="0") @Validator(value=PageOffsetValidator.class) String offsetString, @Parameter(description="The amount of entries the response should be limited to") @Schema(type="integer") @QueryParam(value="limit") @DefaultValue(value="10") @Validator(value=PageLimitValidator.class) String limitString, @Context UriInfo uriInfo) {
        this.requestValidator.isValid(this.getClass(), "queryHistory", uriInfo);
        int offset = Integer.parseInt(offsetString);
        int limit = Integer.parseInt(limitString);
        List<ProcessStatusResponse> processStatusResponses = this.exportJobStateService.getExportJobStates(offset, limit).stream().map(this::getResponseEntity).collect(Collectors.toList());
        boolean isLastPage = processStatusResponses.size() < limit;
        this.publishJobHistoryRequestedAnalyticEvent(offset, limit, processStatusResponses, isLastPage);
        return Response.status((Response.Status)Response.Status.OK).entity(new Page<ProcessStatusResponse>(processStatusResponses, offset, limit, isLastPage)).build();
    }

    private ProcessStatusResponse getResponseEntity(ExportJobState exportJobState) {
        return new ProcessStatusResponse(exportJobState, this.dateConversionUtil::formatToIso, this.datasetProvider.getSchemaStatus(exportJobState.getSchemaVersion()));
    }

    private void publishJobHistoryRequestedAnalyticEvent(int offset, int limit, List<ProcessStatusResponse> processStatusResponses, boolean isLastPage) {
        this.eventPublisherService.publish(new JobHistoryRequestedAnalyticEvent(this.eventPublisherService.getPluginVersion(), isLastPage, limit, offset, processStatusResponses.size()));
    }
}

