/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.core.rest;

import com.atlassian.business.insights.api.dataset.DatasetProvider;
import com.atlassian.business.insights.core.analytics.fileschema.OptOutFileSchemaDeleteTriggeredEvent;
import com.atlassian.business.insights.core.analytics.fileschema.OptOutFileSchemaGetRequestedEvent;
import com.atlassian.business.insights.core.analytics.fileschema.OptOutFileSchemaUpdateTriggeredEvent;
import com.atlassian.business.insights.core.analytics.fileschema.SupportedFileSchemasGetRequestedEvent;
import com.atlassian.business.insights.core.rest.model.ErrorStatusResponse;
import com.atlassian.business.insights.core.rest.model.OptOutFileConfigurationRequest;
import com.atlassian.business.insights.core.rest.model.OptOutFileConfigurationResponse;
import com.atlassian.business.insights.core.rest.model.OptOutFileSummaryResponse;
import com.atlassian.business.insights.core.rest.model.OptOutFileSupportedResponse;
import com.atlassian.business.insights.core.rest.validation.validators.RequestValidator;
import com.atlassian.business.insights.core.service.api.EventPublisherService;
import com.atlassian.business.insights.core.service.api.FileSchemaOptOutService;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.sal.api.message.I18nResolver;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.Serializable;
import java.time.Instant;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

@OpenAPIDefinition(info=@Info(title="Data Pipeline Opt-Out Resource", version="1.0", description="Experimental Data Pipeline API. Configure Data Pipeline opt-out file settings. The root path is /rest/datapipeline/{VERSION} e.g. /rest/datapipeline/1.0, /rest/datapipeline/latest"))
@Path(value="/config/optout-files")
@SystemAdminOnly
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class OptOutFileSchemaRestResource {
    private static final String INVALID_FILE_SCHEMA_I18N_KEY = "data-pipeline.api.rest.config.optout.request.body.file.schemas.invalid";
    private final FileSchemaOptOutService fileSchemaOptOutService;
    private final EventPublisherService eventPublisherService;
    private final I18nResolver i18nResolver;
    private final RequestValidator requestValidator;
    private final DatasetProvider datasetProvider;

    @Inject
    public OptOutFileSchemaRestResource(FileSchemaOptOutService fileSchemaOptOutService, EventPublisherService eventPublisherService, I18nResolver i18nResolver, RequestValidator requestValidator, DatasetProvider datasetProvider) {
        this.fileSchemaOptOutService = fileSchemaOptOutService;
        this.eventPublisherService = eventPublisherService;
        this.i18nResolver = i18nResolver;
        this.requestValidator = requestValidator;
        this.datasetProvider = datasetProvider;
    }

    @Operation(summary="List all supported files that can be opted out", tags={"data pipeline"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Returns all the supported files that can be opted out.", content={@Content(schema=@Schema(implementation=OptOutFileSupportedResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(array=@ArraySchema(schema=@Schema(implementation=Response.class)))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(implementation=ErrorStatusResponse.class))})})
    @GET
    @Path(value="/supported-files")
    public Response getSupportedFileSchemas(@Context UriInfo uriInfo) {
        this.requestValidator.isValid(this.getClass(), "getSupportedFileSchemas", uriInfo);
        this.publishSupportedSchemaRequestedAnalyticEvent();
        return Response.ok().entity((Object)new OptOutFileSupportedResponse(this.getSupportedFileSchemas())).build();
    }

    @Operation(summary="List all opt-out files", tags={"data pipeline"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Returns all the opt-out files that have been added.", content={@Content(schema=@Schema(implementation=OptOutFileSummaryResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(array=@ArraySchema(schema=@Schema(implementation=Response.class)))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(implementation=ErrorStatusResponse.class))})})
    @GET
    public Response getOptOutFileSchemas(@Context UriInfo uriInfo) {
        this.requestValidator.isValid(this.getClass(), "getOptOutFileSchemas", uriInfo);
        this.publishOptOutFileSchemaGetRequestedAnalyticEvent();
        return Response.ok().entity((Object)new OptOutFileSummaryResponse(this.fileSchemaOptOutService.getFileSchemaOptOuts())).build();
    }

    @Operation(summary="Add opt-out files.", tags={"data pipeline"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Returns the opt-out files that have been added and all the opt-out files after addition", content={@Content(schema=@Schema(implementation=OptOutFileConfigurationResponse.class))}), @ApiResponse(responseCode="400", description="Bad request", content={@Content(schema=@Schema(implementation=ErrorStatusResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(array=@ArraySchema(schema=@Schema(implementation=Response.class)))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(implementation=ErrorStatusResponse.class))})})
    @PUT
    public Response addOptOutFileSchemas(@RequestBody @Parameter(required=true) OptOutFileConfigurationRequest optOutFileConfigurationRequest, @Context UriInfo uriInfo) {
        this.requestValidator.isValid(this.getClass(), "addOptOutFileSchemas", uriInfo);
        this.publishOptOutOutFileSchemaUpdateTriggeredAnalyticEvent();
        this.validateSupportedFileSchemas(optOutFileConfigurationRequest);
        this.fileSchemaOptOutService.addFileSchemaOptOuts(optOutFileConfigurationRequest.getFileSchemas());
        return Response.ok().entity((Object)new OptOutFileConfigurationResponse(optOutFileConfigurationRequest.getFileSchemas(), this.fileSchemaOptOutService.getFileSchemaOptOuts())).build();
    }

    @Operation(summary="delete opt-out files.", tags={"data pipeline"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Returns the opt-out files that have been deleted and all the opt-out files after deletion", content={@Content(schema=@Schema(implementation=OptOutFileConfigurationResponse.class))}), @ApiResponse(responseCode="400", description="Bad request", content={@Content(schema=@Schema(implementation=ErrorStatusResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content(array=@ArraySchema(schema=@Schema(implementation=Response.class)))}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content(schema=@Schema(implementation=ErrorStatusResponse.class))})})
    @DELETE
    public Response deleteFileOptOutSchemas(@RequestBody @Parameter(required=true) OptOutFileConfigurationRequest optOutFileConfigurationRequest, @Context UriInfo uriInfo) {
        this.requestValidator.isValid(this.getClass(), "deleteFileOptOutSchemas", uriInfo);
        this.publishOptOutFileSchemaDeleteTriggeredAnalyticEvent();
        this.validateSupportedFileSchemas(optOutFileConfigurationRequest);
        this.fileSchemaOptOutService.deleteFileSchemaOptOuts(optOutFileConfigurationRequest.getFileSchemas());
        return Response.ok().entity((Object)new OptOutFileConfigurationResponse(optOutFileConfigurationRequest.getFileSchemas(), this.fileSchemaOptOutService.getFileSchemaOptOuts())).build();
    }

    private void validateSupportedFileSchemas(OptOutFileConfigurationRequest optOutFileConfigurationRequest) throws WebApplicationException {
        Set<String> supportedFileSchemas = this.getSupportedFileSchemas();
        HashSet<String> invalidFileSchemas = new HashSet<String>();
        for (String fileSchema : optOutFileConfigurationRequest.getFileSchemas()) {
            if (supportedFileSchemas.contains(fileSchema)) continue;
            invalidFileSchemas.add(fileSchema);
        }
        if (!invalidFileSchemas.isEmpty()) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorStatusResponse(Response.Status.BAD_REQUEST.getStatusCode(), this.i18nResolver.getText(INVALID_FILE_SCHEMA_I18N_KEY, new Serializable[]{this.convertFileSchemasAsString(invalidFileSchemas), this.convertFileSchemasAsString(supportedFileSchemas)}), null, Instant.now().toString())).build());
        }
    }

    private Set<String> getSupportedFileSchemas() {
        return this.datasetProvider.getAllDatasets().stream().flatMap(dataset -> dataset.getChannels().stream()).flatMap(dataChannel -> dataChannel.getSchema().getFileSchemas().stream()).map(fileSchema -> fileSchema.getFileNamePrefix()).collect(Collectors.toSet());
    }

    private String convertFileSchemasAsString(Set<String> fileSchemas) {
        return fileSchemas.stream().collect(Collectors.joining(",", "[", "]"));
    }

    private void publishOptOutOutFileSchemaUpdateTriggeredAnalyticEvent() {
        this.eventPublisherService.publish(new OptOutFileSchemaUpdateTriggeredEvent(this.eventPublisherService.getPluginVersion()));
    }

    private void publishOptOutFileSchemaDeleteTriggeredAnalyticEvent() {
        this.eventPublisherService.publish(new OptOutFileSchemaDeleteTriggeredEvent(this.eventPublisherService.getPluginVersion()));
    }

    private void publishOptOutFileSchemaGetRequestedAnalyticEvent() {
        this.eventPublisherService.publish(new OptOutFileSchemaGetRequestedEvent(this.eventPublisherService.getPluginVersion()));
    }

    private void publishSupportedSchemaRequestedAnalyticEvent() {
        this.eventPublisherService.publish(new SupportedFileSchemasGetRequestedEvent(this.eventPublisherService.getPluginVersion()));
    }
}

