/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.core.rest;

import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import com.google.common.collect.ImmutableMap;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Map;

@OpenAPIDefinition(info=@Info(title="Data Pipeline Export Resource", version="0.0.0", description="Experimental Data Pipeline API. Report the current status of Data Pipeline processes on the host product. The root path is /rest/datapipeline/latest"))
@Path(value="/ping")
@LicensedOnly
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@UnrestrictedAccess
public class StatusResource {
    @Inject
    public StatusResource() {
    }

    @Operation(summary="Check the Data Pipeline REST API is available.", tags={"data pipeline"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Successful. The Data Pipeline REST API is available", content={@Content(schema=@Schema(implementation=Map.class))})})
    @GET
    public Response ping() {
        return Response.ok((Object)ImmutableMap.of((Object)"ping", (Object)"success")).build();
    }
}

