/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.core.rest.model;

import com.atlassian.business.insights.core.service.ExportPathHolder;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class ConfigExportPathResponse {
    private String rootExportPath;
    private boolean customPathSet;

    public ConfigExportPathResponse() {
    }

    @JsonCreator
    public ConfigExportPathResponse(@Nonnull @JsonProperty(value="rootExportPath") String rootExportPath, @JsonProperty(value="customPathSet") boolean customPathSet) {
        this.rootExportPath = Objects.requireNonNull(rootExportPath, "rootExportPath must not be null");
        this.customPathSet = customPathSet;
    }

    public static ConfigExportPathResponse from(@Nonnull ExportPathHolder exportPathHolder) {
        return new ConfigExportPathResponse(exportPathHolder.getRootExportPath().toAbsolutePath().toString(), exportPathHolder.isCustom());
    }

    @JsonProperty(value="rootExportPath")
    public String getRootExportPath() {
        return this.rootExportPath;
    }

    @JsonProperty(value="customPathSet")
    public boolean isCustomPathSet() {
        return this.customPathSet;
    }
}

