/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.core.rest.model;

import com.atlassian.business.insights.core.rest.exception.InvalidDayException;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum Weekdays {
    MONDAY("mon"),
    TUESDAY("tue"),
    WEDNESDAY("wed"),
    THURSDAY("thu"),
    FRIDAY("fri"),
    SATURDAY("sat"),
    SUNDAY("sun");

    private static final Map<String, Weekdays> DAYS_MAP;
    private final String dayAbbreviation;

    private Weekdays(String dayAbbreviation) {
        this.dayAbbreviation = dayAbbreviation;
    }

    @JsonCreator
    public static Weekdays fromString(@Nonnull String dayStr) {
        try {
            return Optional.ofNullable(DAYS_MAP.get(dayStr.toLowerCase())).orElseGet(() -> Weekdays.valueOf(dayStr.toUpperCase()));
        }
        catch (Exception exception) {
            throw new InvalidDayException(dayStr);
        }
    }

    @JsonValue
    public String getAbbreviation() {
        return this.dayAbbreviation;
    }

    static {
        DAYS_MAP = Stream.of(Weekdays.values()).collect(Collectors.toMap(Weekdays::getAbbreviation, Function.identity()));
    }
}

