/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.core.rest.validation.validators.queryparam;

import com.atlassian.business.insights.core.rest.exception.InvalidQueryParamException;
import com.atlassian.business.insights.core.rest.validation.ValidationResult;
import com.atlassian.business.insights.core.rest.validation.validators.queryparam.QueryParamValidator;
import com.atlassian.business.insights.core.rest.validation.validators.queryparam.Validator;
import jakarta.annotation.Nonnull;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

public class QueryParamsValidator {
    private static final String MISSING_PARAM = "data-pipeline.api.rest.queryparam.declared.parameter.missing.value";

    public void validate(Class<?> resourceClass, String methodName, UriInfo uriInfo) {
        Method method = this.findMethodInClass(resourceClass, methodName);
        MultivaluedMap queryParameters = uriInfo.getQueryParameters();
        ValidationResult validationResult = new ValidationResult();
        Arrays.stream(method.getParameters()).filter(this::parameterHasRequiredAnnotations).forEach(parameter -> this.validateParameter((MultivaluedMap<String, String>)queryParameters, validationResult, (Parameter)parameter));
        if (validationResult.hasErrors()) {
            throw new InvalidQueryParamException(validationResult);
        }
    }

    private Method findMethodInClass(Class<?> resourceClass, String methodName) {
        return Arrays.stream(resourceClass.getMethods()).filter(m -> m.getName().equals(methodName)).findFirst().orElseThrow(() -> new RuntimeException(String.format("Method %s is not found", methodName)));
    }

    private boolean parameterHasRequiredAnnotations(Parameter parameter) {
        return parameter.isAnnotationPresent(QueryParam.class) && parameter.isAnnotationPresent(Validator.class);
    }

    private void validateParameter(MultivaluedMap<String, String> queryParameters, ValidationResult validationResult, Parameter parameter) {
        String parameterName = parameter.getAnnotation(QueryParam.class).value();
        String parameterValue = (String)queryParameters.getFirst((Object)parameterName);
        if (parameterValue != null && this.validateFieldIsNotBlank(parameterValue, parameterName, validationResult)) {
            this.validateWithCustomValidator(parameter, parameterValue, validationResult);
        }
    }

    private void validateWithCustomValidator(Parameter parameter, String parameterValue, ValidationResult validationResult) {
        Class validatorClass = parameter.getAnnotation(Validator.class).value();
        QueryParamValidator parameterValidator = this.createValidatorInstance(validatorClass);
        parameterValidator.validate(parameterValue, validationResult);
    }

    private QueryParamValidator createValidatorInstance(Class<? extends QueryParamValidator> validatorClass) {
        try {
            return validatorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("The class " + String.valueOf(validatorClass) + " should have default constructor");
        }
    }

    private boolean validateFieldIsNotBlank(@Nonnull String parameterValue, @Nonnull String parameterName, @Nonnull ValidationResult validationResult) {
        if (StringUtils.isBlank((CharSequence)parameterValue)) {
            validationResult.add(MISSING_PARAM, parameterName);
            return false;
        }
        return true;
    }
}

