/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.business.insights.core.service;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.audit.api.AuditService;
import com.atlassian.business.insights.core.analytics.fileschema.OptOutFileSchemaDeletedEvent;
import com.atlassian.business.insights.core.analytics.fileschema.OptOutFileSchemaUpdateSucceededEvent;
import com.atlassian.business.insights.core.ao.dao.AoDataPipelineConfigDao;
import com.atlassian.business.insights.core.ao.dao.entity.AoDataPipelineConfig;
import com.atlassian.business.insights.core.audit.AuditEventFactory;
import com.atlassian.business.insights.core.service.api.EventPublisherService;
import com.atlassian.business.insights.core.service.api.FileSchemaOptOutService;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DefaultFileSchemaOptOutService
implements FileSchemaOptOutService {
    @VisibleForTesting
    static final String OPTOUT_FILE_SCHEMA_KEY = "file.optouts";
    private final AoDataPipelineConfigDao aoDataPipelineConfigDao;
    private final EventPublisherService eventPublisherService;
    private final AuditService auditService;

    public DefaultFileSchemaOptOutService(AoDataPipelineConfigDao aoDataPipelineConfigDao, EventPublisherService eventPublisherService, AuditService auditService) {
        this.aoDataPipelineConfigDao = Objects.requireNonNull(aoDataPipelineConfigDao, "aoDataPipelineConfigDao must not be null");
        this.eventPublisherService = Objects.requireNonNull(eventPublisherService, "eventPublisherService must not be null");
        this.auditService = Objects.requireNonNull(auditService, "auditService must not be null");
    }

    @Override
    public void addFileSchemaOptOuts(@Nonnull Set<String> fileSchemaOptOuts) {
        Set<String> existingFileSchemaOptOuts = this.getFileSchemaOptOuts();
        if (existingFileSchemaOptOuts.containsAll(fileSchemaOptOuts) || fileSchemaOptOuts.isEmpty()) {
            return;
        }
        HashSet<String> effectiveFileSchemaOptOuts = new HashSet<String>(existingFileSchemaOptOuts);
        effectiveFileSchemaOptOuts.addAll(fileSchemaOptOuts);
        this.aoDataPipelineConfigDao.put(OPTOUT_FILE_SCHEMA_KEY, this.serialiseFileSchemaOptOuts(effectiveFileSchemaOptOuts));
        this.publishOptOutFileSchemaUpdateSucceededEvent();
        this.auditOptOutFileSchemaUpdated(existingFileSchemaOptOuts, effectiveFileSchemaOptOuts);
    }

    @Override
    public void deleteFileSchemaOptOuts(Set<String> fileSchemasToBeRemoved) {
        Set<String> existingFileSchemaOptOuts = this.getFileSchemaOptOuts();
        if (fileSchemasToBeRemoved.isEmpty() || existingFileSchemaOptOuts.isEmpty()) {
            return;
        }
        HashSet<String> remainingFileSchemaOptOuts = new HashSet<String>(existingFileSchemaOptOuts);
        if (fileSchemasToBeRemoved.containsAll(existingFileSchemaOptOuts)) {
            this.aoDataPipelineConfigDao.delete(OPTOUT_FILE_SCHEMA_KEY);
            this.publishOptOutFileSchemaDeletedEventSucceededEvent();
            this.auditOptOutFileSchemaDeleted(existingFileSchemaOptOuts);
        } else {
            remainingFileSchemaOptOuts.removeAll(fileSchemasToBeRemoved);
            this.aoDataPipelineConfigDao.put(OPTOUT_FILE_SCHEMA_KEY, this.serialiseFileSchemaOptOuts(remainingFileSchemaOptOuts));
            this.publishOptOutFileSchemaUpdateSucceededEvent();
            this.auditOptOutFileSchemaUpdated(existingFileSchemaOptOuts, remainingFileSchemaOptOuts);
        }
    }

    @Override
    public Set<String> getFileSchemaOptOuts() {
        return this.aoDataPipelineConfigDao.get(OPTOUT_FILE_SCHEMA_KEY).map(AoDataPipelineConfig::getValue).map(fileSchemaOptOutsConfig -> this.deserialiseFileSchemaOptOuts((String)fileSchemaOptOutsConfig).collect(Collectors.toSet())).orElseGet(Collections::emptySet);
    }

    private String serialiseFileSchemaOptOuts(Collection<String> strings) {
        return String.join((CharSequence)",", strings);
    }

    private Stream<String> deserialiseFileSchemaOptOuts(String fileSchemaOptOutsConfig) {
        return Arrays.stream(fileSchemaOptOutsConfig.split(","));
    }

    private void publishOptOutFileSchemaUpdateSucceededEvent() {
        this.eventPublisherService.publish(new OptOutFileSchemaUpdateSucceededEvent(this.eventPublisherService.getPluginVersion()));
    }

    private void publishOptOutFileSchemaDeletedEventSucceededEvent() {
        this.eventPublisherService.publish(new OptOutFileSchemaDeletedEvent(this.eventPublisherService.getPluginVersion()));
    }

    private void auditOptOutFileSchemaUpdated(Set<String> previousOptOutSchema, Set<String> newOptOutSchema) {
        this.auditService.audit(AuditEventFactory.createOptOutFileSchemaUpdatedAuditEvent(this.serialiseFileSchemaOptOuts(previousOptOutSchema), this.serialiseFileSchemaOptOuts(newOptOutSchema)));
    }

    private void auditOptOutFileSchemaDeleted(Set<String> previousOptOutSchema) {
        this.auditService.audit(AuditEventFactory.createOptOutFileSchemaDeletedAuditEvent(this.serialiseFileSchemaOptOuts(previousOptOutSchema)));
    }
}

