/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.secrets.service;

import com.atlassian.secrets.api.SealedSecret;
import com.atlassian.secrets.api.SealedSecretFormat;
import com.atlassian.secrets.api.SecretServiceException;
import com.atlassian.secrets.service.EncryptionBasedSecret;
import com.atlassian.secrets.service.IdentifierBasedSecret;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import java.util.Base64;
import java.util.regex.Matcher;

public class CBORFormat
implements SealedSecretFormat.SerializationFormat {
    private static final ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new CBORFactory());

    public SealedSecret fromString(String sealedSecret) {
        Matcher matcher = SealedSecretFormat.PREFIX_PATTERN.matcher(sealedSecret);
        if (!matcher.find()) {
            throw new SecretServiceException("Invalid SealedSecret, prefix is missing");
        }
        try {
            String secretType = matcher.group(1);
            sealedSecret = matcher.replaceFirst("");
            byte[] cborBytes = Base64.getDecoder().decode(sealedSecret);
            if (secretType.equals("ID")) {
                return (SealedSecret)objectMapper.readValue(cborBytes, IdentifierBasedSecret.class);
            }
            return (SealedSecret)objectMapper.readValue(cborBytes, EncryptionBasedSecret.class);
        }
        catch (Exception e) {
            throw new SecretServiceException("Error building SealedSecret", (Throwable)e);
        }
    }

    public String toString(SealedSecretFormat.SecretType secretType, SealedSecret sealedSecret) {
        try {
            byte[] cborBytes = objectMapper.writeValueAsBytes((Object)sealedSecret);
            return secretType.getPrefix() + new String(Base64.getEncoder().encode(cborBytes));
        }
        catch (JsonProcessingException e) {
            throw new SecretServiceException((Throwable)e);
        }
    }
}

