/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.secrets.service;

import com.atlassian.secrets.api.SealedSecret;
import com.atlassian.secrets.api.SecretDao;
import com.atlassian.secrets.api.SecretService;
import com.atlassian.secrets.api.SecretServiceConfiguration;
import com.atlassian.secrets.api.SecretServiceException;
import com.atlassian.secrets.api.SecretServiceType;
import com.atlassian.secrets.service.DefaultSecretServiceManagement;
import com.atlassian.secrets.service.SecretServiceBackend;
import com.atlassian.secrets.service.SecretServiceParams;
import com.atlassian.secrets.service.clusterlock.ClusterLockOperator;
import com.atlassian.secrets.service.clusterlock.DefaultClusterLockOperator;
import com.atlassian.secrets.service.config.SecretServiceConfig;
import com.atlassian.secrets.service.internal.DefaultSecretServiceInterface;
import com.atlassian.secrets.service.internal.SecretBackendContainer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class DefaultSecretService
implements SecretService,
DefaultSecretServiceInterface {
    private static final int MAX_SECRET_SIZE = 65536;
    private static final Logger log = LoggerFactory.getLogger(DefaultSecretService.class);
    private final SecretDao secretDao;
    private final SecretBackendContainer backends;
    private final SecretService.SecretServiceManagement secretServiceManagement;
    private final ClusterLockOperator clusterLockOperator;

    public DefaultSecretService(SecretServiceParams params, Map<String, SecretServiceBackend> backends, String defaultBackendId) {
        this.secretDao = params.getSecretDao();
        this.backends = new SecretBackendContainer(backends, defaultBackendId);
        this.secretServiceManagement = new DefaultSecretServiceManagement(this, params);
        this.clusterLockOperator = new DefaultClusterLockOperator(params.getClusterLockServiceSupplier());
    }

    DefaultSecretService(SecretServiceParams params, Map<String, SecretServiceBackend> backends, String defaultBackendId, SecretService.SecretServiceManagement secretServiceManagement) {
        this.secretDao = params.getSecretDao();
        this.backends = new SecretBackendContainer(backends, defaultBackendId);
        this.secretServiceManagement = secretServiceManagement;
        this.clusterLockOperator = new DefaultClusterLockOperator(params.getClusterLockServiceSupplier());
    }

    private static void validateSecretDataSize(String plainTextToSecure) throws SecretServiceException {
        byte[] dataInBytes = plainTextToSecure.getBytes(StandardCharsets.UTF_8);
        if (dataInBytes.length > 65536) {
            throw new SecretServiceException("Secret data size exceeds the 64KB limit.");
        }
    }

    public void put(String identifier, String data) throws SecretServiceException {
        Assert.hasText((String)identifier, (String)"Secret identifier must not be empty.");
        this.clusterLockOperator.maybePerformWithLock(() -> {
            log.debug("Putting secret {}", (Object)identifier);
            DefaultSecretService.validateSecretDataSize(data);
            this.secretServiceManagement.reloadConfiguration();
            SealedSecret sealedSecret = this.backends.getDefaultBackend().seal(identifier, data);
            this.secretDao.put(Collections.singleton(sealedSecret));
        });
    }

    public Optional<String> get(String identifier) throws SecretServiceException {
        Assert.hasText((String)identifier, (String)"Secret identifier must not be empty.");
        log.debug("Getting secret {}", (Object)identifier);
        Optional maybeSealedSecret = this.secretDao.get(identifier);
        if (maybeSealedSecret.isEmpty()) {
            log.debug("Secret {} not found", (Object)identifier);
            return Optional.empty();
        }
        SealedSecret sealedSecret = (SealedSecret)maybeSealedSecret.get();
        String backendId = sealedSecret.getBackendId();
        Optional<SecretServiceBackend> maybeBackend = this.backends.getBackend(backendId);
        if (maybeBackend.isEmpty()) {
            log.info("Found unknown backend: {}", (Object)backendId);
            this.secretServiceManagement.reloadConfiguration();
            maybeBackend = this.backends.getBackend(backendId);
            if (maybeBackend.isEmpty()) {
                throw new SecretServiceException("Cannot get secret from unknown backend: " + backendId);
            }
        }
        SecretServiceBackend backend = maybeBackend.get();
        return Optional.of(backend.unseal(sealedSecret));
    }

    public void delete(String identifier) throws SecretServiceException {
        Assert.hasText((String)identifier, (String)"Secret identifier must not be empty.");
        this.clusterLockOperator.maybePerformWithLock(() -> {
            log.debug("Deleting secret {}", (Object)identifier);
            Optional maybeSealedSecret = this.secretDao.get(identifier);
            if (maybeSealedSecret.isEmpty()) {
                return;
            }
            SealedSecret sealedSecret = (SealedSecret)maybeSealedSecret.get();
            String backendId = sealedSecret.getBackendId();
            this.secretServiceManagement.reloadConfiguration();
            Optional<SecretServiceBackend> maybeBackend = this.backends.getBackend(backendId);
            if (maybeBackend.isEmpty()) {
                throw new SecretServiceException("Cannot delete secret from unknown backend: " + backendId);
            }
            SecretServiceBackend backend = maybeBackend.get();
            backend.delete(identifier);
            this.secretDao.delete(identifier);
        });
    }

    public SecretServiceConfiguration getConfiguration() {
        this.secretServiceManagement.reloadConfiguration();
        return this.backends.getConfiguration();
    }

    public SecretService.SecretServiceManagement getManagement() {
        return this.secretServiceManagement;
    }

    @Override
    public SecretServiceType getDefaultBackendType() {
        return this.backends.getDefaultBackend().getType();
    }

    @Override
    public void migrateTo(SecretServiceBackend newDefaultBackend) {
        this.backends.migrateTo(this.secretDao, newDefaultBackend);
    }

    @Override
    public SecretServiceConfig getCurrentConfig() {
        return this.backends.getCurrentSecretServiceConfig();
    }

    @Override
    public void reconfigure(Map<String, SecretServiceBackend> newBackends, String defaultBackendId) {
        log.info("Re-configuring SecretService to use new default backend: {}", (Object)defaultBackendId);
        this.backends.reconfigure(newBackends, defaultBackendId);
    }

    SecretServiceBackend getDefaultBackend() {
        return this.backends.getDefaultBackend();
    }
}

