/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.secrets.service;

import com.atlassian.secrets.api.SealedSecret;
import com.atlassian.secrets.api.SealedSecretFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class IdentifierBasedSecret
implements SealedSecret {
    private final String identifier;
    private final String backendId;

    public IdentifierBasedSecret(@JsonProperty(value="identifier", required=true) String identifier, @JsonProperty(value="backendId", required=true) String backendId) {
        this.identifier = identifier;
        this.backendId = backendId;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getBackendId() {
        return this.backendId;
    }

    public String toString() {
        return SealedSecretFormat.getFormat().toString(SealedSecretFormat.SecretType.ID, (SealedSecret)this);
    }

    public boolean equals(Object other) {
        if (!(other instanceof IdentifierBasedSecret)) {
            return false;
        }
        IdentifierBasedSecret otherSecret = (IdentifierBasedSecret)other;
        return this.identifier.equals(otherSecret.identifier) && this.backendId.equals(otherSecret.backendId);
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.backendId);
    }
}

