/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.secrets.service;

import com.atlassian.secrets.api.SecretService;
import com.atlassian.secrets.api.SecretServiceException;
import com.atlassian.secrets.api.SecretServiceState;
import com.atlassian.secrets.service.DefaultSecretService;
import com.atlassian.secrets.service.DisabledSecretService;
import com.atlassian.secrets.service.SecretConfigManager;
import com.atlassian.secrets.service.SecretServiceBackend;
import com.atlassian.secrets.service.SecretServiceParams;
import com.atlassian.secrets.service.config.DefaultSecretServiceConfigParser;
import com.atlassian.secrets.service.config.SecretServiceConfig;
import com.atlassian.secrets.service.lock.ConfigLock;
import com.atlassian.secrets.service.utils.OSUtils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecretServiceFactory {
    private static final Logger log = LoggerFactory.getLogger(SecretServiceFactory.class);
    public static final String SECRETS_CONFIG_LOCK_FILE_NAME = "secrets-config.yaml.lock";
    public static final String CONFIG_GENERATION_LOCKING_DISABLED = "atlassian.secret.service.lock.disabled";

    private SecretServiceFactory() {
    }

    public static SecretService getSecretService(SecretServiceParams params) throws SecretServiceException {
        Map<String, SecretServiceBackend> backends;
        if (SecretService.getState() == SecretServiceState.DISABLED) {
            return new DisabledSecretService();
        }
        Path configFile = params.getSecretsConfigFile();
        SecretServiceConfig secretServiceConfig = SecretServiceFactory.getOrCreateConfig(params);
        try {
            DefaultSecretServiceConfigParser configParser = new DefaultSecretServiceConfigParser();
            backends = configParser.parseBackends(secretServiceConfig, params);
        }
        catch (Exception e) {
            String errorMessage = String.format("Backend properties in secret service configuration file is invalid, review the %s file.", configFile.getFileName());
            throw new SecretServiceException(errorMessage);
        }
        String defaultBackend = secretServiceConfig.getDefaultBackend();
        SecretServiceBackend defaultService = backends.get(defaultBackend);
        if (defaultService == null) {
            throw new IllegalArgumentException(String.format("Default service must be a valid backend. Make sure %s is appropriately defined.", configFile.getFileName()));
        }
        return new DefaultSecretService(params, backends, defaultBackend);
    }

    private static SecretServiceConfig getOrCreateConfig(SecretServiceParams params) {
        Path configFile = params.getSecretsConfigFile();
        if (!Files.exists(configFile, new LinkOption[0])) {
            if (OSUtils.isWindows() || Boolean.getBoolean(CONFIG_GENERATION_LOCKING_DISABLED)) {
                log.debug("Skipping lock file creation as it is not supported or has been explicitly disabled.");
                SecretConfigManager.maybeGenerateDefaultConfigFile(params);
            } else {
                ConfigLock configLock = params.getConfigLockSupplier().get();
                configLock.releaseStaleLock();
                configLock.runWithLock(() -> SecretConfigManager.maybeGenerateDefaultConfigFile(params));
            }
        }
        return SecretConfigManager.readConfigFile(configFile);
    }
}

