/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.secrets.service;

import com.atlassian.beehive.ClusterLockService;
import com.atlassian.secrets.api.SecretDao;
import com.atlassian.secrets.service.file.AtomicFileWriter;
import com.atlassian.secrets.service.file.FileWriter;
import com.atlassian.secrets.service.lock.ConfigFileLock;
import com.atlassian.secrets.service.lock.ConfigLock;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Supplier;
import org.springframework.util.Assert;

public class SecretServiceParams {
    public static final String SECRETS_CONFIG_FILE_NAME = "secrets-config.yaml";
    public static final String SECRET_KEY_DIR = "keys";
    public static final FileWriter DEFAULT_FILE_WRITER = new AtomicFileWriter();
    private final Path secretsConfigFile;
    private final Path keyDirectory;
    private final SecretDao secretDao;
    private final FileWriter fileWriter;
    private final Supplier<ClusterLockService> clusterLockServiceSupplier;
    private final Supplier<ConfigLock> configLockSupplier;

    private SecretServiceParams(SecretServiceParamsBuilder secretServiceParamsBuilder) {
        Assert.notNull((Object)secretServiceParamsBuilder.secretsConfigFile, (String)"secretsConfigFile cannot be null, set the home directory or set explicitly with SecretServiceParamsBuilder");
        Assert.notNull((Object)secretServiceParamsBuilder.keyDirectory, (String)"keyDirectory cannot be null, set the home directory or set explicitly with SecretServiceParamsBuilder");
        Assert.notNull((Object)secretServiceParamsBuilder.secretDao, (String)"secretDao cannot be null");
        this.secretsConfigFile = secretServiceParamsBuilder.secretsConfigFile;
        this.keyDirectory = secretServiceParamsBuilder.keyDirectory;
        this.secretDao = secretServiceParamsBuilder.secretDao;
        this.fileWriter = Optional.ofNullable(secretServiceParamsBuilder.fileWriter).orElse(DEFAULT_FILE_WRITER);
        this.clusterLockServiceSupplier = secretServiceParamsBuilder.clusterLockServiceSupplier;
        this.configLockSupplier = Optional.ofNullable(secretServiceParamsBuilder.configLockSupplier).orElse(() -> new ConfigFileLock(this.secretsConfigFile));
    }

    public static SecretServiceParamsBuilder builder() {
        return new SecretServiceParamsBuilder();
    }

    public Path getSecretsConfigFile() {
        return this.secretsConfigFile;
    }

    public Path getKeyDirectory() {
        return this.keyDirectory;
    }

    public SecretDao getSecretDao() {
        return this.secretDao;
    }

    public FileWriter getFileWriter() {
        return this.fileWriter;
    }

    public Supplier<ClusterLockService> getClusterLockServiceSupplier() {
        return this.clusterLockServiceSupplier;
    }

    public Supplier<ConfigLock> getConfigLockSupplier() {
        return this.configLockSupplier;
    }

    public static class SecretServiceParamsBuilder {
        private Path secretsConfigFile;
        private Path keyDirectory;
        private SecretDao secretDao;
        private FileWriter fileWriter;
        private Supplier<ClusterLockService> clusterLockServiceSupplier;
        private Supplier<ConfigLock> configLockSupplier;

        public SecretServiceParamsBuilder setHomeDirectory(Path homeDirectory) {
            this.secretsConfigFile = homeDirectory.resolve(SecretServiceParams.SECRETS_CONFIG_FILE_NAME);
            this.keyDirectory = homeDirectory.resolve(SecretServiceParams.SECRET_KEY_DIR);
            return this;
        }

        public SecretServiceParamsBuilder setSecretsConfigFile(Path secretsConfigFile) {
            this.secretsConfigFile = secretsConfigFile;
            return this;
        }

        public SecretServiceParamsBuilder setKeysDirectory(Path keyDirectory) {
            this.keyDirectory = keyDirectory;
            return this;
        }

        public SecretServiceParamsBuilder setSecretDao(SecretDao secretDao) {
            this.secretDao = secretDao;
            return this;
        }

        public SecretServiceParamsBuilder setFileWriter(FileWriter fileWriter) {
            this.fileWriter = fileWriter;
            return this;
        }

        public SecretServiceParamsBuilder setClusterLockServiceSupplier(Supplier<ClusterLockService> clusterLockServiceSupplier) {
            this.clusterLockServiceSupplier = clusterLockServiceSupplier;
            return this;
        }

        public SecretServiceParamsBuilder setConfigLockSupplier(Supplier<ConfigLock> configLockSupplier) {
            this.configLockSupplier = configLockSupplier;
            return this;
        }

        public SecretServiceParams build() {
            return new SecretServiceParams(this);
        }
    }
}

