/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.secrets.service.aes;

import com.atlassian.secrets.api.SecretServiceException;
import com.atlassian.secrets.service.SecretConfigManager;
import com.atlassian.secrets.service.aes.AESBackendGenerator;
import com.atlassian.secrets.service.aes.AESConfig;
import com.atlassian.secrets.service.aes.AESEncryptionBackend;
import com.atlassian.secrets.service.aes.SecurityProvider;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.time.Clock;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.UUID;
import java.util.function.Supplier;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAESBackendGenerator
implements AESBackendGenerator {
    private static final Logger log = LoggerFactory.getLogger(DefaultAESBackendGenerator.class);
    private final Supplier<String> suffixSupplier;
    public static final String SECRET_SERVICE_PREFIX = "ATL_SECRET";
    public static final String KEY_NAME_PREFIX = "ATL_SECRET_AES_256";

    public DefaultAESBackendGenerator() {
        this(DefaultAESBackendGenerator::generateSuffix);
    }

    DefaultAESBackendGenerator(Supplier<String> suffixSupplier) {
        this.suffixSupplier = suffixSupplier;
    }

    @Override
    public AESEncryptionBackend generate(Path secretKeyDirectory) {
        String backendName = this.generateName();
        Path secretKeyPath = this.generateDefaultKey(secretKeyDirectory, backendName);
        SecretConfigManager.applyReadOnlyPermissionsTo(SecretConfigManager.isPosixFilesystem, secretKeyPath);
        AESConfig aesConfig = new AESConfig(secretKeyPath);
        return new AESEncryptionBackend(backendName, aesConfig);
    }

    private Path generateDefaultKey(Path secretKeyDirectory, String backendName) {
        try {
            SecretKeySpec encryptionKeySpec = this.generateSecretKey();
            Path encryptionKeyPath = secretKeyDirectory.resolve(backendName);
            if (!Files.exists(secretKeyDirectory, new LinkOption[0])) {
                Files.createDirectories(secretKeyDirectory, new FileAttribute[0]);
            }
            Files.write(encryptionKeyPath, encryptionKeySpec.getEncoded(), new OpenOption[0]);
            return encryptionKeyPath.toAbsolutePath();
        }
        catch (SecretServiceException e) {
            throw e;
        }
        catch (Exception e) {
            String errorMessage = "Problem when trying to write the default AES encryption key file.";
            log.error(errorMessage);
            throw new SecretServiceException(errorMessage, (Throwable)e);
        }
    }

    private SecretKeySpec generateSecretKey() {
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance("AES", SecurityProvider.get());
            keyGen.init(256);
            return (SecretKeySpec)keyGen.generateKey();
        }
        catch (GeneralSecurityException e) {
            throw new SecretServiceException("Error when generating the AES key", (Throwable)e);
        }
    }

    private String generateName() {
        return String.format("%s_%s", KEY_NAME_PREFIX, this.suffixSupplier.get());
    }

    private static String generateSuffix() {
        DateTimeFormatter suffixTimeFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd-HHmmss").withZone(ZoneOffset.UTC);
        return String.format("%s_%s", suffixTimeFormat.format(Clock.systemUTC().instant()), UUID.randomUUID());
    }
}

