/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.secrets.service.aws;

import com.atlassian.secrets.api.SealedSecret;
import com.atlassian.secrets.api.SecretServiceException;
import com.atlassian.secrets.api.SecretServiceType;
import com.atlassian.secrets.aws.DefaultSecretsManagerClientFactory;
import com.atlassian.secrets.aws.SecretsManagerClientFactory;
import com.atlassian.secrets.service.IdentifierBasedSecret;
import com.atlassian.secrets.service.SecretConfigManager;
import com.atlassian.secrets.service.SecretServiceBackend;
import com.atlassian.secrets.service.aws.AWSSecretBackendConfig;
import com.atlassian.secrets.service.config.BackendConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.model.CreateSecretRequest;
import software.amazon.awssdk.services.secretsmanager.model.CreateSecretResponse;
import software.amazon.awssdk.services.secretsmanager.model.DeleteSecretRequest;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueRequest;
import software.amazon.awssdk.services.secretsmanager.model.PutSecretValueRequest;
import software.amazon.awssdk.services.secretsmanager.model.PutSecretValueResponse;
import software.amazon.awssdk.services.secretsmanager.model.ResourceNotFoundException;
import software.amazon.awssdk.services.secretsmanager.model.RestoreSecretRequest;

public class AWSSecretBackend
implements SecretServiceBackend {
    public static final String AWS_FORCE_DELETE_SECRET_SYSTEM_PROP_KEY = "secret.service.aws.force.delete.secret";
    private static final Logger log = LoggerFactory.getLogger(AWSSecretBackend.class);
    private final String backendId;
    private final AWSSecretBackendConfig config;
    private final SecretsManagerClientFactory clientFactory;

    public AWSSecretBackend(String backendId, AWSSecretBackendConfig config) {
        this(backendId, config, (SecretsManagerClientFactory)new DefaultSecretsManagerClientFactory());
    }

    public AWSSecretBackend(String backendId, AWSSecretBackendConfig config, SecretsManagerClientFactory factory) {
        this.backendId = backendId;
        this.config = config;
        this.clientFactory = factory;
    }

    @Override
    public SealedSecret seal(String identifier, String plainTextToSecure) throws SecretServiceException {
        Assert.hasText((String)identifier, (String)"Secret identifier must not be empty.");
        try {
            SecretsManagerClient client = this.getClient();
            String secretName = this.getSecretName(identifier);
            try {
                PutSecretValueRequest request = (PutSecretValueRequest)PutSecretValueRequest.builder().secretId(secretName).secretString(plainTextToSecure).build();
                PutSecretValueResponse response = client.putSecretValue(request);
                client.restoreSecret((RestoreSecretRequest)RestoreSecretRequest.builder().secretId(secretName).build());
                log.debug("Updated AWS secret: {}", (Object)response.name());
            }
            catch (ResourceNotFoundException resourceNotFoundException) {
                CreateSecretRequest request = (CreateSecretRequest)CreateSecretRequest.builder().name(secretName).secretString(plainTextToSecure).description("Atlassian Data Center Managed Secret").build();
                CreateSecretResponse response = client.createSecret(request);
                log.debug("Created AWS secret: {}", (Object)response.name());
            }
            return new IdentifierBasedSecret(identifier, this.backendId);
        }
        catch (RuntimeException e) {
            log.error("Problem when saving a secret value into AWS Secret Manager: {}", (Object)e.getMessage());
            throw new SecretServiceException("Problem when saving a secret value into AWS Secret Manager", (Throwable)e);
        }
    }

    @Override
    public String unseal(SealedSecret sealedSecret) throws SecretServiceException {
        if (!(sealedSecret instanceof IdentifierBasedSecret)) {
            throw new SecretServiceException("Expecting secret identifier but encrypted secret was passed in");
        }
        try {
            IdentifierBasedSecret identifierBasedSecret = (IdentifierBasedSecret)sealedSecret;
            SecretsManagerClient client = this.getClient();
            String secretName = this.getSecretName(identifierBasedSecret.getIdentifier());
            GetSecretValueRequest request = (GetSecretValueRequest)GetSecretValueRequest.builder().secretId(secretName).build();
            String rawSecretValue = client.getSecretValue(request).secretString();
            log.debug("Retrieved AWS secret: {}", (Object)identifierBasedSecret.getIdentifier());
            return rawSecretValue;
        }
        catch (Exception e) {
            log.error("Problem when getting the secret value from AWS Secret Manager: {}", (Object)e.getMessage());
            throw new SecretServiceException("Problem when getting the secret value from AWS Secret Manager", (Throwable)e);
        }
    }

    @Override
    public void delete(String identifier) throws SecretServiceException {
        try {
            log.debug("Deleting the secret with the identifier of {} in AWS.", (Object)identifier);
            SecretsManagerClient client = this.getClient();
            String secretName = this.getSecretName(identifier);
            DeleteSecretRequest request = (DeleteSecretRequest)DeleteSecretRequest.builder().secretId(secretName).forceDeleteWithoutRecovery(Boolean.valueOf(AWSSecretBackend.getBooleanValueFor(AWS_FORCE_DELETE_SECRET_SYSTEM_PROP_KEY, true))).build();
            client.deleteSecret(request);
            log.debug("Deleted AWS secret: {}", (Object)identifier);
        }
        catch (ResourceNotFoundException e) {
            log.info("Cannot find the secret value associated with the provided secret identifier");
        }
        catch (Exception e) {
            log.error("Problem when deleting the secret value from AWS Secret Manager: {}", (Object)e.getMessage());
            throw new SecretServiceException("Problem when deleting the secret value from AWS Secret Manager", (Throwable)e);
        }
    }

    @Override
    public SecretServiceType getType() {
        return SecretServiceType.AWS;
    }

    @Override
    public String getId() {
        return this.backendId;
    }

    @Override
    public BackendConfig getBackendConfig() {
        return SecretConfigManager.convertToBackendConfig(SecretServiceType.AWS, this.config);
    }

    private SecretsManagerClient getClient() {
        return this.config.getEndpointOverride() != null ? this.clientFactory.getClient(this.config.getRegion(), this.config.getEndpointOverride()) : this.clientFactory.getClient(this.config.getRegion());
    }

    private String getSecretName(String identifier) {
        return this.config.getSecretNamePrefix() != null ? String.format("%s/%s", this.config.getSecretNamePrefix(), identifier) : identifier;
    }

    private static boolean getBooleanValueFor(String sysPropKey, boolean defaultValue) {
        String value = System.getProperty(sysPropKey);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }
}

