/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.secrets.service.aws;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URI;
import org.springframework.util.StringUtils;
import software.amazon.awssdk.regions.Region;

public class AWSSecretBackendConfig {
    private final Region region;
    private final URI endpointOverride;
    private final String secretNamePrefix;

    public AWSSecretBackendConfig(@JsonProperty(value="region", required=true) String region, @JsonProperty(value="secretNamePrefix", required=true) String secretNamePrefix, @JsonProperty(value="endpointOverride") String endpointOverride) {
        if (!Region.regions().contains(Region.of((String)region))) {
            throw new IllegalArgumentException("Invalid region");
        }
        this.region = Region.of((String)region);
        if (!StringUtils.hasText((String)secretNamePrefix)) {
            throw new IllegalArgumentException("secretNamePrefix must be a text String");
        }
        this.secretNamePrefix = secretNamePrefix;
        this.endpointOverride = endpointOverride != null ? URI.create(endpointOverride) : null;
    }

    public String getSecretNamePrefix() {
        return this.secretNamePrefix;
    }

    public Region getRegion() {
        return this.region;
    }

    @JsonProperty(value="region")
    public String getStringRegion() {
        return this.region.toString();
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public URI getEndpointOverride() {
        return this.endpointOverride;
    }
}

