/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.secrets.service.clusterlock;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.secrets.api.SecretServiceException;
import com.atlassian.secrets.service.clusterlock.ClusterLockOperator;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class DefaultClusterLockOperator
implements ClusterLockOperator {
    private static final Logger log = LoggerFactory.getLogger(ClusterLockOperator.class);
    private static final Long DEFAULT_TIMEOUT = 10L;
    private final Supplier<ClusterLockService> clusterLockServiceSupplier;
    public static final String SECRET_SERVICE_MUTATION_LOCK_NAME = "secret.service.data.mutation.lock";
    public static final String SECRET_SERVICE_LOCK_TIMEOUT = "secret.service.data.mutation.lock.timeout";

    public DefaultClusterLockOperator(Supplier<ClusterLockService> clusterLockServiceSupplier) {
        this.clusterLockServiceSupplier = clusterLockServiceSupplier;
    }

    @Override
    public void maybePerformWithLock(Runnable runnable) {
        Optional<ClusterLockService> clusterLockService = this.getClusterLockServiceIfAvailable();
        if (clusterLockService.isPresent()) {
            DefaultClusterLockOperator.doPerformWithLock(runnable, clusterLockService.get());
            return;
        }
        runnable.run();
    }

    @Override
    public void performWithLock(Runnable runnable) {
        ClusterLockService clusterLockService = this.clusterLockServiceSupplier.get();
        Assert.notNull((Object)clusterLockService, (String)"Cluster Lock Service is required for this operation");
        DefaultClusterLockOperator.doPerformWithLock(runnable, clusterLockService);
    }

    @Override
    public Optional<ClusterLockService> getClusterLockServiceIfAvailable() {
        try {
            ClusterLockService service = this.clusterLockServiceSupplier.get();
            if (service != null) {
                return Optional.of(service);
            }
            log.debug("Cluster lock is not ready");
            return Optional.empty();
        }
        catch (Exception e) {
            log.debug("Cannot get cluster lock service", (Throwable)e);
            return Optional.empty();
        }
    }

    private static void doPerformWithLock(Runnable runnable, ClusterLockService clusterLockService) {
        ClusterLock lock = clusterLockService.getLockForName(SECRET_SERVICE_MUTATION_LOCK_NAME);
        boolean lockAcquired = false;
        try {
            lockAcquired = lock.tryLock(DefaultClusterLockOperator.getTimeoutValue().longValue(), TimeUnit.SECONDS);
            if (!lockAcquired) {
                throw new SecretServiceException("Unable to acquire cluster lock");
            }
            runnable.run();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SecretServiceException("Thread was interrupted while trying to acquire cluster lock", (Throwable)e);
        }
        finally {
            if (lockAcquired) {
                DefaultClusterLockOperator.tryUnlock(lock);
            }
        }
    }

    private static Long getTimeoutValue() throws SecretServiceException {
        return System.getProperty(SECRET_SERVICE_LOCK_TIMEOUT) != null ? Long.parseLong(System.getProperty(SECRET_SERVICE_LOCK_TIMEOUT)) : DEFAULT_TIMEOUT;
    }

    private static void tryUnlock(ClusterLock lock) {
        try {
            lock.unlock();
        }
        catch (Exception e) {
            throw new SecretServiceException("Unable to unlock cluster lock", (Throwable)e);
        }
    }
}

