/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.secrets.service.config;

import com.atlassian.secrets.api.SealedSecretFormat;
import com.atlassian.secrets.api.SecretServiceException;
import com.atlassian.secrets.api.SecretServiceType;
import com.atlassian.secrets.service.CBORFormat;
import com.atlassian.secrets.service.SecretServiceBackend;
import com.atlassian.secrets.service.SecretServiceParams;
import com.atlassian.secrets.service.aes.AESConfig;
import com.atlassian.secrets.service.aes.AESEncryptionBackend;
import com.atlassian.secrets.service.aws.AWSSecretBackend;
import com.atlassian.secrets.service.aws.AWSSecretBackendConfig;
import com.atlassian.secrets.service.config.BackendConfig;
import com.atlassian.secrets.service.config.SecretServiceConfig;
import com.atlassian.secrets.service.config.SecretServiceConfigParser;
import com.atlassian.secrets.service.vault.VaultSecretBackend;
import com.atlassian.secrets.vault.auth.VaultConfig;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.stream.Collectors;

public class DefaultSecretServiceConfigParser
implements SecretServiceConfigParser {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public Map<String, SecretServiceBackend> parseBackends(SecretServiceConfig config, SecretServiceParams params) {
        return config.getBackends().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> DefaultSecretServiceConfigParser.getSecretService((String)entry.getKey(), (BackendConfig)entry.getValue(), params)));
    }

    private static SecretServiceBackend getSecretService(String backendId, BackendConfig backendConfig, SecretServiceParams params) throws SecretServiceException {
        SecretServiceType type = backendConfig.getType();
        Map<String, Object> properties = backendConfig.getProperties();
        SealedSecretFormat.setFormat((SealedSecretFormat.SerializationFormat)new CBORFormat());
        return switch (type) {
            default -> throw new MatchException(null, null);
            case SecretServiceType.AES -> {
                AESConfig aesDataStoreConfig = DefaultSecretServiceConfigParser.mapToServiceConfig(properties, AESConfig.class).withResolvedKey(params.getKeyDirectory());
                yield new AESEncryptionBackend(backendId, aesDataStoreConfig);
            }
            case SecretServiceType.VAULT -> {
                VaultConfig vaultConfig = DefaultSecretServiceConfigParser.mapToServiceConfig(properties, VaultConfig.class);
                yield new VaultSecretBackend(backendId, vaultConfig);
            }
            case SecretServiceType.AWS -> {
                AWSSecretBackendConfig awsConfig = DefaultSecretServiceConfigParser.mapToServiceConfig(properties, AWSSecretBackendConfig.class);
                yield new AWSSecretBackend(backendId, awsConfig);
            }
        };
    }

    public static <T> T mapToServiceConfig(Map<String, Object> properties, Class<T> configType) {
        return (T)objectMapper.convertValue(properties, configType);
    }
}

