/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.secrets.service.internal;

import com.atlassian.secrets.api.SecretDao;
import com.atlassian.secrets.api.SecretServiceConfiguration;
import com.atlassian.secrets.api.SecretServiceException;
import com.atlassian.secrets.service.SecretServiceBackend;
import com.atlassian.secrets.service.config.BackendConfig;
import com.atlassian.secrets.service.config.SecretServiceConfig;
import com.atlassian.secrets.service.internal.MigrationHelpers;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.util.Assert;

public class SecretBackendContainer {
    private final Map<String, SecretServiceBackend> backends = new HashMap<String, SecretServiceBackend>();
    private SecretServiceBackend defaultBackend = null;

    public SecretBackendContainer(Map<String, SecretServiceBackend> backends, String defaultBackendId) {
        this.reconfigure(backends, defaultBackendId);
    }

    public synchronized void migrateTo(SecretDao secretDao, SecretServiceBackend newDefaultBackend) {
        Assert.notNull((Object)newDefaultBackend, (String)"Default backend cannot be null");
        if (this.backends.containsKey(newDefaultBackend.getId())) {
            throw new SecretServiceException("Secret backend with id " + newDefaultBackend.getId() + " already exists");
        }
        this.backends.put(newDefaultBackend.getId(), newDefaultBackend);
        for (SecretServiceBackend backend : this.backends.values()) {
            if (backend.equals(newDefaultBackend)) continue;
            MigrationHelpers.migrate(secretDao, backend, newDefaultBackend);
        }
        this.defaultBackend = newDefaultBackend;
        this.backends.entrySet().removeIf(entry -> !((String)entry.getKey()).equals(this.defaultBackend.getId()));
    }

    public synchronized void reconfigure(Map<String, SecretServiceBackend> newBackends, String defaultBackendId) {
        SecretServiceBackend newDefault = newBackends.get(defaultBackendId);
        Assert.notNull((Object)newDefault, (String)String.format("%s it not a valid backend id", defaultBackendId));
        this.defaultBackend = newDefault;
        this.backends.clear();
        this.backends.putAll(newBackends);
    }

    public synchronized SecretServiceBackend getDefaultBackend() {
        return this.defaultBackend;
    }

    public synchronized Optional<SecretServiceBackend> getBackend(String id) {
        SecretServiceBackend backend = this.backends.get(id);
        if (backend == null) {
            return Optional.empty();
        }
        return Optional.of(backend);
    }

    public synchronized SecretServiceConfiguration getConfiguration() {
        Set backendTypes = this.backends.values().stream().map(SecretServiceBackend::getType).collect(Collectors.toSet());
        return new SecretServiceConfiguration(this.defaultBackend.getType(), backendTypes);
    }

    public synchronized SecretServiceConfig getCurrentSecretServiceConfig() {
        HashMap<String, BackendConfig> backendConfigMap = new HashMap<String, BackendConfig>();
        this.backends.forEach((key, value) -> backendConfigMap.put((String)key, value.getBackendConfig()));
        return new SecretServiceConfig(this.defaultBackend.getId(), backendConfigMap);
    }
}

