/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.secrets.service.vault;

import com.atlassian.secrets.api.SealedSecret;
import com.atlassian.secrets.api.SecretServiceException;
import com.atlassian.secrets.api.SecretServiceType;
import com.atlassian.secrets.service.IdentifierBasedSecret;
import com.atlassian.secrets.service.SecretConfigManager;
import com.atlassian.secrets.service.SecretServiceBackend;
import com.atlassian.secrets.service.config.BackendConfig;
import com.atlassian.secrets.vault.DefaultVaultTemplateFactory;
import com.atlassian.secrets.vault.VaultTemplateFactory;
import com.atlassian.secrets.vault.VaultUtils;
import com.atlassian.secrets.vault.auth.DefaultVaultAuthenticationProvider;
import com.atlassian.secrets.vault.auth.VaultAuthenticationProvider;
import com.atlassian.secrets.vault.auth.VaultConfig;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.vault.core.VaultTemplate;
import org.springframework.vault.support.Versioned;

public class VaultSecretBackend
implements SecretServiceBackend {
    private static final Logger log = LoggerFactory.getLogger(VaultSecretBackend.class);
    public static final String SECRET_KEY = "value";
    private final String backendId;
    private final VaultConfig config;
    private final VaultAuthenticationProvider authenticationProvider;
    private final VaultTemplateFactory templateFactory;
    private VaultTemplate vaultTemplate;

    public VaultSecretBackend(String backendId, VaultConfig config) {
        this(backendId, config, (VaultTemplateFactory)new DefaultVaultTemplateFactory(), (VaultAuthenticationProvider)new DefaultVaultAuthenticationProvider());
    }

    public VaultSecretBackend(String backendId, VaultConfig vaultConfig, VaultTemplateFactory templateFactory, VaultAuthenticationProvider authenticationProvider) {
        this.backendId = backendId;
        this.config = vaultConfig;
        this.templateFactory = templateFactory;
        this.authenticationProvider = authenticationProvider;
    }

    @Override
    public SealedSecret seal(String identifier, String plainTextToSecure) throws SecretServiceException {
        Assert.hasText((String)identifier, (String)"Secret identifier must not be empty.");
        try {
            Map<String, String> secretData = Collections.singletonMap(SECRET_KEY, plainTextToSecure);
            String secretPath = this.getSecretPath(identifier);
            this.getVaultTemplate().opsForVersionedKeyValue(this.config.getMount()).put(secretPath, secretData);
            log.debug("Stored secret in Vault on path {}", (Object)secretPath);
            return new IdentifierBasedSecret(identifier, this.backendId);
        }
        catch (RuntimeException e) {
            throw new SecretServiceException("Problem when saving the secret value to HashiCorp Vault", (Throwable)e);
        }
    }

    @Override
    public String unseal(SealedSecret sealedSecret) throws SecretServiceException {
        if (!(sealedSecret instanceof IdentifierBasedSecret)) {
            throw new SecretServiceException("Expecting secret with identifier but encrypted secret was passed in.");
        }
        try {
            String secretPath = this.getSecretPath(sealedSecret.getIdentifier());
            log.debug("Retrieving secret from Vault on mount {} and path {}.", (Object)secretPath, (Object)this.config.getMount());
            Versioned readResponse = this.getVaultTemplate().opsForVersionedKeyValue(this.config.getMount()).get(secretPath);
            log.debug("Retrieved secret from Vault on path {}.", (Object)secretPath);
            return VaultUtils.getSecretValueFromReadResponse((Versioned)readResponse, (String)SECRET_KEY);
        }
        catch (RuntimeException e) {
            throw new SecretServiceException("Problem when getting the secret value from HashiCorp Vault", (Throwable)e);
        }
    }

    @Override
    public void delete(String identifier) throws SecretServiceException {
        try {
            String secretPath = this.getSecretPath(identifier);
            log.debug("Deleting secret from Vault on mount {} and path {}.", (Object)secretPath, (Object)this.config.getMount());
            this.getVaultTemplate().opsForVersionedKeyValue(this.config.getMount()).delete(secretPath);
            log.debug("Deleted secret from Vault on path {}.", (Object)secretPath);
        }
        catch (RuntimeException e) {
            throw new SecretServiceException("Problem when deleting the secret value from Vault", (Throwable)e);
        }
    }

    @Override
    public SecretServiceType getType() {
        return SecretServiceType.VAULT;
    }

    @Override
    public String getId() {
        return this.backendId;
    }

    @Override
    public BackendConfig getBackendConfig() {
        return SecretConfigManager.convertToBackendConfig(SecretServiceType.VAULT, this.config);
    }

    private synchronized VaultTemplate getVaultTemplate() {
        if (this.vaultTemplate == null) {
            this.vaultTemplate = this.templateFactory.getTemplate(URI.create(this.config.getEndpoint()), this.authenticationProvider.getAuthentication(this.config));
        }
        return this.vaultTemplate;
    }

    String getSecretPath(String identifier) {
        return String.format("%s/%s", this.config.getPath(), identifier);
    }
}

