/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.web.descriptors;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.descriptors.AbstractWebFragmentModuleDescriptor;
import com.atlassian.plugin.web.descriptors.WebItemModuleDescriptor;
import com.atlassian.plugin.web.model.DefaultWebIcon;
import com.atlassian.plugin.web.model.DefaultWebLink;
import com.atlassian.plugin.web.model.WebIcon;
import com.atlassian.plugin.web.model.WebLink;
import org.apache.commons.lang3.StringUtils;

public class DefaultWebItemModuleDescriptor
extends AbstractWebFragmentModuleDescriptor<Void>
implements WebItemModuleDescriptor {
    private String section;
    private WebIcon icon;
    private DefaultWebLink link;
    private String styleClass;
    private String entryPoint;
    private Element element;

    public DefaultWebItemModuleDescriptor(WebInterfaceManager webInterfaceManager) {
        super(webInterfaceManager);
    }

    public DefaultWebItemModuleDescriptor() {
    }

    @Override
    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.element = element;
        this.section = element.attributeValue("section");
        this.styleClass = element.element("styleClass") != null ? element.element("styleClass").getTextTrim() : "";
        this.entryPoint = element.element("entry-point") != null ? element.element("entry-point").getTextTrim() : "";
    }

    @Override
    public String getSection() {
        return this.section;
    }

    @Override
    public WebLink getLink() {
        return this.link;
    }

    @Override
    public WebIcon getIcon() {
        return this.icon;
    }

    @Override
    public String getStyleClass() {
        return this.styleClass;
    }

    @Override
    public String getEntryPoint() {
        if (StringUtils.isNotBlank((CharSequence)this.entryPoint)) {
            if (this.entryPoint.matches("^.+:.+$")) {
                return this.entryPoint;
            }
            return this.plugin.getKey() + ":" + this.entryPoint;
        }
        return null;
    }

    @Override
    public void enabled() {
        Element linkElement;
        super.enabled();
        Element iconElement = this.element.element("icon");
        if (iconElement != null) {
            this.icon = new DefaultWebIcon(iconElement, this.webInterfaceManager.getWebFragmentHelper(), this.contextProvider, this);
        }
        if ((linkElement = this.element.element("link")) != null) {
            this.link = new DefaultWebLink(linkElement, this.webInterfaceManager.getWebFragmentHelper(), this.contextProvider, this);
        }
    }

    public Void getModule() {
        return null;
    }
}

