/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.web.model;

import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.loaders.LoaderUtils;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.plugin.web.WebFragmentHelper;
import com.atlassian.plugin.web.api.descriptors.WebFragmentModuleDescriptor;
import com.atlassian.plugin.web.model.AbstractWebItem;
import com.atlassian.plugin.web.model.WebLabel;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class DefaultWebLabel
extends AbstractWebItem
implements WebLabel {
    private final String key;
    private final String noKeyValue;
    protected SortedMap<String, String> params;

    public DefaultWebLabel(Element labelEl, WebFragmentHelper webFragmentHelper, ContextProvider contextProvider, WebFragmentModuleDescriptor descriptor) throws PluginParseException {
        super(webFragmentHelper, contextProvider, descriptor);
        this.params = new TreeMap<String, String>(LoaderUtils.getParams((Element)labelEl));
        if (labelEl == null) {
            throw new PluginParseException("You must specify a label for the section.");
        }
        this.key = labelEl.attributeValue("key");
        this.noKeyValue = this.key == null ? labelEl.getTextTrim() : null;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getDisplayableLabel(HttpServletRequest req, Map<String, Object> origContext) {
        HashMap<String, Object> tmpContext = new HashMap<String, Object>(origContext);
        tmpContext.putAll(this.getContextMap(tmpContext));
        if (this.key != null) {
            if (this.params == null || this.params.isEmpty()) {
                return this.getWebFragmentHelper().getI18nValue(this.key, null, tmpContext);
            }
            ArrayList<String> arguments = new ArrayList<String>();
            for (Map.Entry<String, String> entry : this.params.entrySet()) {
                if (!entry.getKey().startsWith("param")) continue;
                arguments.add(this.getWebFragmentHelper().renderVelocityFragment(entry.getValue(), tmpContext));
            }
            return this.getWebFragmentHelper().getI18nValue(this.key, arguments, tmpContext);
        }
        return this.getWebFragmentHelper().renderVelocityFragment(this.noKeyValue, tmpContext);
    }

    public SortedMap<String, String> getParams() {
        return this.params;
    }
}

