/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jpos.confluencemacro;

import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import java.text.MessageFormat;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PlanHtmlTransform
implements UnaryOperator<String> {
    private static final String QUOTES_ESCAPED_UNICODE = "\\u0022";
    private static final String QUOTES_ESCAPED = "\\\"";
    private static final String BASE_URL_PROPERTY_MATCHER = "{0}baseUrl{0}:{0}";
    private static final String REST_URL_PROPERTY_MATCHER = "{0}restUrl{0}:{0}";
    private static final Pattern SHORTCUTS_JS_PATTERN = Pattern.compile("src=\"(.*)/rest/api/1.0/shortcuts");
    private static final String SHORTCUT_JS_LINK_FORMAT = "src=\"%s/rest/api/1.0/shortcuts";
    private static final Pattern CONTEXT_PATH_PATTERN = Pattern.compile("\"com.atlassian.plugins.atlassian-plugins-webresource-plugin:context-path.context-path\"]=\"(.*)\"");
    private static final String CONTEXT_PATH_FORMAT = "\"com.atlassian.plugins.atlassian-plugins-webresource-plugin:context-path.context-path\"]=\"{0}%s{0}\"";
    private static final String APP_LINK_PROXY_URL_BASE_FORMAT = "{0}/plugins/servlet/arj-proxy?appId={1}&path=";
    private final String jiraBaseUrl;
    private final String appLinkedUrl;

    public PlanHtmlTransform(ReadOnlyApplicationLink jiraApplicationLink, String confluenceBaseUrl, boolean useRPCUrl) {
        this.jiraBaseUrl = useRPCUrl ? jiraApplicationLink.getRpcUrl().toString() : jiraApplicationLink.getDisplayUrl().toString();
        this.appLinkedUrl = MessageFormat.format(APP_LINK_PROXY_URL_BASE_FORMAT, confluenceBaseUrl, jiraApplicationLink.getId().get());
    }

    @Override
    public String apply(String planHtml) {
        String transformed = this.setJiraBaseUrl(planHtml);
        transformed = this.rerouteAJSContextPathToProxy(transformed);
        transformed = this.rerouteShortcutsJsToProxy(transformed);
        transformed = this.rerouteJpoRestUrlToProxy(transformed);
        return transformed;
    }

    private String setJiraBaseUrl(String planHtml) {
        String headElement = "<head>";
        int headElementStartIndex = planHtml.lastIndexOf(headElement);
        if (headElementStartIndex > 0) {
            int headElementEndIndex = planHtml.lastIndexOf(headElement) + headElement.length();
            return planHtml.substring(0, headElementEndIndex) + "\n<base href=\"" + this.jiraBaseUrl + "\" />\n" + planHtml.substring(headElementEndIndex);
        }
        return planHtml;
    }

    private String rerouteShortcutsJsToProxy(String planHtml) {
        return SHORTCUTS_JS_PATTERN.matcher(planHtml).replaceAll(Matcher.quoteReplacement(String.format(SHORTCUT_JS_LINK_FORMAT, this.appLinkedUrl)));
    }

    private String rerouteAJSContextPathToProxy(String planHtml) {
        int unicodeIndex;
        Matcher contextPathMatcher = CONTEXT_PATH_PATTERN.matcher(planHtml);
        String contextPathFormat = MessageFormat.format(CONTEXT_PATH_FORMAT, QUOTES_ESCAPED);
        if (contextPathMatcher.find() && (unicodeIndex = contextPathMatcher.group().indexOf(QUOTES_ESCAPED_UNICODE)) > 0) {
            contextPathFormat = MessageFormat.format(CONTEXT_PATH_FORMAT, QUOTES_ESCAPED_UNICODE);
        }
        return contextPathMatcher.replaceAll(Matcher.quoteReplacement(String.format(contextPathFormat, this.appLinkedUrl)));
    }

    private String rerouteJpoRestUrlToProxy(String planHtml) {
        return this.checkBaseURLAndCheckRestIfPresent(planHtml, QUOTES_ESCAPED).orElseGet(() -> this.checkBaseURLAndCheckRestIfPresent(planHtml, QUOTES_ESCAPED_UNICODE).orElse(planHtml));
    }

    private Optional<String> checkBaseURLAndCheckRestIfPresent(String planHtml, String escapeKey) {
        Optional<String> baseUrlUnicode = this.getPropertyFromPlanHtml(planHtml, BASE_URL_PROPERTY_MATCHER, escapeKey);
        if (baseUrlUnicode.isPresent()) {
            return this.checkRestUrlAndReplaceIfPresent(planHtml, baseUrlUnicode.get(), escapeKey);
        }
        return Optional.empty();
    }

    private Optional<String> checkRestUrlAndReplaceIfPresent(String planHtml, String baseUrl, String escapeKey) {
        Optional<String> restUrl = this.getPropertyFromPlanHtml(planHtml, REST_URL_PROPERTY_MATCHER, escapeKey);
        if (restUrl.isPresent()) {
            String restContext = restUrl.get().replace(baseUrl, "");
            String proxyUrl = this.appLinkedUrl + restContext;
            return Optional.of(planHtml.replace(restUrl.get(), proxyUrl));
        }
        return Optional.empty();
    }

    private Optional<String> getPropertyFromPlanHtml(String content, String searchKey, String escapeKey) {
        int startIndex;
        int endIndex;
        int searchIndex = content.indexOf(searchKey = MessageFormat.format(searchKey, escapeKey));
        if (searchIndex > 0 && (endIndex = content.indexOf(escapeKey, startIndex = searchIndex + searchKey.length())) >= startIndex) {
            return Optional.of(content.substring(startIndex, endIndex));
        }
        return Optional.empty();
    }
}

