/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.retention;

import com.atlassian.confluence.api.model.retention.SoftCleanupJobStatus;
import com.atlassian.confluence.api.service.retention.SoftCleanupStatusService;
import com.atlassian.confluence.util.DefaultObjectMapperProvider;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSoftCleanupStatusService
implements SoftCleanupStatusService {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSoftCleanupStatusService.class);
    protected final PluginSettings globalPluginSettings;
    protected ObjectMapper objectMapper;

    protected AbstractSoftCleanupStatusService(PluginSettingsFactory pluginSettingsFactory) {
        this.globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        this.objectMapper = new DefaultObjectMapperProvider().getObjectMapper();
    }

    public abstract String getStatusPluginSettingsKey();

    public SoftCleanupJobStatus getCurrentStatus() {
        Object status = this.globalPluginSettings.get(this.getStatusPluginSettingsKey());
        return this.parseStatusFromPluginSettingsValue(status);
    }

    public void setCurrentStatus(SoftCleanupJobStatus status) {
        try {
            this.globalPluginSettings.put(this.getStatusPluginSettingsKey(), (Object)this.objectMapper.writeValueAsString((Object)status));
        }
        catch (IOException e) {
            logger.error("Error writing VersionsRemovalStatus: {}", (Object)e.getMessage());
        }
    }

    protected abstract SoftCleanupJobStatus parseStatusFromPluginSettingsValue(Object var1);
}

