/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.retention;

import com.atlassian.confluence.api.model.retention.RuleScope;
import com.atlassian.confluence.api.model.retention.SoftCleanupJobStatus;
import com.atlassian.confluence.api.service.retention.RetentionFeatureChecker;
import com.atlassian.confluence.api.service.retention.SoftCleanupStatusService;
import com.atlassian.confluence.core.persistence.hibernate.CacheMode;
import com.atlassian.confluence.core.persistence.hibernate.SessionCacheModeThreadLocal;
import com.atlassian.confluence.impl.cluster.lock.ClusterLockExecutionService;
import com.atlassian.confluence.impl.retention.HistoricalVersionService;
import com.atlassian.confluence.impl.retention.VersionRemovalEventPublisher;
import com.atlassian.confluence.impl.retention.VersionRemovalService;
import com.atlassian.confluence.impl.retention.rules.DeletedHistoricalVersionSummary;
import com.atlassian.confluence.impl.retention.rules.EvaluatedHistoricalVersion;
import com.atlassian.confluence.impl.retention.rules.HistoricalVersion;
import com.atlassian.confluence.retention.SpaceRetentionPolicyManager;
import com.atlassian.confluence.util.Cleanup;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public abstract class AbstractVersionRemovalService
implements VersionRemovalService {
    private static final Logger logger = LoggerFactory.getLogger(AbstractVersionRemovalService.class);
    public static final String RETENTION_RULES_DELETION_BATCH_SIZE_KEY = "confluence.retention.rules.batch.size";
    public static final Long DEFAULT_START_ORIGINAL_ID = 0L;
    protected static final int DELETION_BATCH_SIZE = Integer.getInteger("confluence.retention.rules.batch.size", 200);
    protected final HistoricalVersionService historicalVersionService;
    protected final SoftCleanupStatusService softCleanupStatusService;
    protected final VersionRemovalEventPublisher versionRemovalEventPublisher;
    protected final PlatformTransactionManager transactionManager;
    protected final RetentionFeatureChecker retentionFeatureChecker;
    protected final SpaceRetentionPolicyManager spaceRetentionPolicyManager;
    protected final ClusterLockExecutionService clusterLockExecutionService;

    protected AbstractVersionRemovalService(HistoricalVersionService historicalVersionService, SoftCleanupStatusService softCleanupStatusService, VersionRemovalEventPublisher versionRemovalEventPublisher, PlatformTransactionManager transactionManager, RetentionFeatureChecker retentionFeatureChecker, SpaceRetentionPolicyManager spaceRetentionPolicyManager, ClusterLockExecutionService clusterLockExecutionService) {
        this.historicalVersionService = historicalVersionService;
        this.softCleanupStatusService = softCleanupStatusService;
        this.versionRemovalEventPublisher = versionRemovalEventPublisher;
        this.transactionManager = transactionManager;
        this.retentionFeatureChecker = retentionFeatureChecker;
        this.spaceRetentionPolicyManager = spaceRetentionPolicyManager;
        this.clusterLockExecutionService = clusterLockExecutionService;
    }

    protected Cleanup setCacheMode() {
        return SessionCacheModeThreadLocal.temporarilySetCacheMode((CacheMode)CacheMode.IGNORE);
    }

    protected void saveJobStatus(SoftCleanupJobStatus status) {
        logger.debug("Saving SoftCleanupJobStatus [{}]", (Object)status);
        this.softCleanupStatusService.setCurrentStatus(status);
    }

    protected List<DeletedHistoricalVersionSummary> deleteForRule(List<EvaluatedHistoricalVersion> evaluated, RuleScope ruleScope) {
        return this.deleteHistoricalVersionsInBatches(evaluated.stream().filter(EvaluatedHistoricalVersion::getShouldBeDeleted).filter(evaluatedHistoricalVersion -> evaluatedHistoricalVersion.getRuleScope().equals((Object)ruleScope)).map(EvaluatedHistoricalVersion::getHistoricalVersion).toList());
    }

    private List<DeletedHistoricalVersionSummary> deleteHistoricalVersionsInBatches(List<HistoricalVersion> contentToDelete) {
        ArrayList<DeletedHistoricalVersionSummary> removalSummaries = new ArrayList<DeletedHistoricalVersionSummary>();
        Iterators.partition(contentToDelete.iterator(), (int)DELETION_BATCH_SIZE).forEachRemaining(historicalVersions -> removalSummaries.addAll(this.deleteHistoricalVersions((List<HistoricalVersion>)historicalVersions)));
        return removalSummaries;
    }

    private List<DeletedHistoricalVersionSummary> deleteHistoricalVersions(List<HistoricalVersion> historicalVersions) {
        if (!this.retentionFeatureChecker.isDryRunModeEnabled()) {
            try {
                return Collections.singletonList((DeletedHistoricalVersionSummary)this.getTransactionTemplate().execute(transactionStatus -> this.historicalVersionService.delete(historicalVersions)));
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Historical version batch delete failed, retry deletion one by one.");
                }
                return historicalVersions.stream().map(this::deleteHistoricalVersion).toList();
            }
        }
        return Collections.singletonList(new DeletedHistoricalVersionSummary.Builder().build());
    }

    private DeletedHistoricalVersionSummary deleteHistoricalVersion(HistoricalVersion historicalVersion) {
        try {
            return (DeletedHistoricalVersionSummary)this.getTransactionTemplate().execute(transactionStatus -> this.historicalVersionService.delete(Collections.singletonList(historicalVersion)));
        }
        catch (Exception e) {
            logger.error("Failed to delete historical version: {}", (Object)historicalVersion, (Object)e);
            return new DeletedHistoricalVersionSummary.Builder().build();
        }
    }

    protected TransactionTemplate getTransactionTemplate() {
        TransactionTemplate transactionTemplate = new TransactionTemplate(this.transactionManager);
        transactionTemplate.setPropagationBehavior(3);
        transactionTemplate.setIsolationLevel(-1);
        transactionTemplate.setName("VersionRemovalService");
        return transactionTemplate;
    }
}

