/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.retention;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.dmz.ContentEntityManagerInternal;
import com.atlassian.confluence.dmz.pages.AttachmentManagerInternal;
import com.atlassian.confluence.impl.retention.ContentRetentionDao;
import com.atlassian.confluence.impl.retention.HistoricalVersionService;
import com.atlassian.confluence.impl.retention.rules.ContentType;
import com.atlassian.confluence.impl.retention.rules.DeletedHistoricalVersion;
import com.atlassian.confluence.impl.retention.rules.DeletedHistoricalVersionSummary;
import com.atlassian.confluence.impl.retention.rules.HistoricalVersion;
import com.atlassian.confluence.pages.Attachment;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHistoricalVersionService
implements HistoricalVersionService {
    private static final Logger log = LoggerFactory.getLogger(DefaultHistoricalVersionService.class);
    private final ContentRetentionDao contentRetentionDao;
    private final ContentEntityManagerInternal contentEntityManagerInternal;
    private final AttachmentManagerInternal attachmentManagerInternal;

    public DefaultHistoricalVersionService(ContentRetentionDao contentRetentionDao, ContentEntityManagerInternal contentEntityManagerInternal, AttachmentManagerInternal attachmentManagerInternal) {
        this.contentRetentionDao = contentRetentionDao;
        this.contentEntityManagerInternal = contentEntityManagerInternal;
        this.attachmentManagerInternal = attachmentManagerInternal;
    }

    @Override
    public List<HistoricalVersion> find(long startOriginalId, int limit, ContentType contentType) {
        this.debug("Finding Historical {} Content for content IDs starting with {}, result limit [{}]", new Object[]{contentType, startOriginalId, limit});
        if (contentType == ContentType.PAGE) {
            return this.contentRetentionDao.findHistoricalPageVersions(startOriginalId, limit);
        }
        return this.contentRetentionDao.findHistoricalAttachmentVersions(startOriginalId, limit);
    }

    @Override
    public DeletedHistoricalVersionSummary delete(List<HistoricalVersion> historicalVersionList) {
        this.debug("Deleting [{}] items", historicalVersionList.size());
        List<DeletedHistoricalVersion> pageResults = historicalVersionList.stream().filter(historicalContent -> ContentType.PAGE == historicalContent.getContentType()).map(this::deletePageVersion).collect(Collectors.toList());
        List<DeletedHistoricalVersion> attachmentResults = historicalVersionList.stream().filter(historicalContent -> ContentType.ATTACHMENT == historicalContent.getContentType()).map(this::deleteAttachmentVersion).collect(Collectors.toList());
        long maxId = historicalVersionList.stream().filter(Objects::nonNull).mapToLong(HistoricalVersion::getOriginalId).max().orElse(0L);
        return this.createSummary(pageResults, attachmentResults, maxId);
    }

    private DeletedHistoricalVersionSummary createSummary(List<DeletedHistoricalVersion> pageResults, List<DeletedHistoricalVersion> attachmentResults, long maxId) {
        long pageVersionsRemoved = pageResults.stream().filter(version -> !version.isFailed()).filter(version -> version.getContentType().equals((Object)ContentType.PAGE)).count();
        long attachmentVersionsRemoved = attachmentResults.stream().filter(version -> !version.isFailed()).filter(version -> version.getContentType().equals((Object)ContentType.ATTACHMENT)).count();
        long attachmentSizeRemoved = attachmentResults.stream().filter(Objects::nonNull).mapToLong(DeletedHistoricalVersion::getAttachmentSize).sum();
        return new DeletedHistoricalVersionSummary.Builder().pageVersionsRemoved(pageVersionsRemoved).attachmentVersionsRemoved(attachmentVersionsRemoved).attachmentSizeRemoved(attachmentSizeRemoved).lastIdProcessed(maxId).build();
    }

    private DeletedHistoricalVersion deletePageVersion(HistoricalVersion historicalContent) {
        try {
            ContentEntityObject oldVersion = this.contentEntityManagerInternal.getById(historicalContent.getId().longValue());
            if (oldVersion != null) {
                this.contentEntityManagerInternal.removeHistoricalVersion(oldVersion);
            }
            this.debug("historical version deleted: {}", historicalContent);
            return new DeletedHistoricalVersion.Builder().contentType(ContentType.PAGE).build();
        }
        catch (Exception ex) {
            log.error("Version remove failed: error deleting Historical page Version [{}]", (Object)historicalContent, (Object)ex);
            return this.buildFailedDeletedVersion(ContentType.PAGE, historicalContent.getOriginalId());
        }
    }

    private DeletedHistoricalVersion deleteAttachmentVersion(HistoricalVersion historicalContent) {
        try {
            Attachment attachment = this.attachmentManagerInternal.getAttachment(historicalContent.getId().longValue());
            if (attachment != null) {
                this.attachmentManagerInternal.removeAttachmentVersionFromServerWithoutNotifications(attachment);
                long filesize = attachment.getProperties().getLongProperty("FILESIZE", 0L);
                this.debug("historical version deleted: {}", historicalContent);
                return new DeletedHistoricalVersion.Builder().contentType(ContentType.ATTACHMENT).attachmentSize(filesize).build();
            }
            this.debug("Version remove failed: skipping the deletion of null historical attachment Version [{}]", historicalContent);
            return this.buildFailedDeletedVersion(ContentType.ATTACHMENT, historicalContent.getOriginalId());
        }
        catch (Exception ex) {
            log.error("Version remove failed: error deleting Historical attachment Version [{}] ", (Object)historicalContent, (Object)ex);
            return this.buildFailedDeletedVersion(ContentType.ATTACHMENT, historicalContent.getOriginalId());
        }
    }

    private DeletedHistoricalVersion buildFailedDeletedVersion(ContentType contentType, long originalId) {
        return new DeletedHistoricalVersion.Builder().contentType(contentType).isFailed().originalId(originalId).build();
    }

    private void debug(String format, Object ... arguments) {
        if (log.isDebugEnabled()) {
            log.debug(format, arguments);
        }
    }
}

