/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.retention.fast;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.api.model.retention.RuleScope;
import com.atlassian.confluence.api.model.retention.TrashRetentionRule;
import com.atlassian.confluence.api.service.retention.RetentionFeatureChecker;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.dmz.pages.TrashManagerInternal;
import com.atlassian.confluence.impl.cluster.lock.ClusterLockExecutionService;
import com.atlassian.confluence.impl.retention.RemovalType;
import com.atlassian.confluence.impl.retention.analytics.TrashRemovalJobCompletedEvent;
import com.atlassian.confluence.impl.retention.analytics.TrashRemovalStatisticHolder;
import com.atlassian.confluence.impl.retention.analytics.TrashRemovalStatisticThreadLocal;
import com.atlassian.confluence.impl.retention.fast.dao.FastContentRetentionDao;
import com.atlassian.confluence.impl.retention.fast.dao.FastSpaceRetentionDao;
import com.atlassian.confluence.impl.retention.fast.status.FastTrashCleanupJobStatus;
import com.atlassian.confluence.impl.retention.fast.status.FastTrashCleanupJobStatusManager;
import com.atlassian.confluence.impl.retention.manager.AbstractTrashRemovalManager;
import com.atlassian.confluence.impl.retention.manager.GlobalRetentionPolicyManager;
import com.atlassian.confluence.impl.retention.rules.EvaluatedTrash;
import com.atlassian.confluence.impl.retention.rules.TrashRuleEvaluator;
import com.atlassian.confluence.util.Cleanup;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.features.DarkFeatureManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;

public class FastTrashRemovalManager
extends AbstractTrashRemovalManager {
    private static final Logger log = LoggerFactory.getLogger(FastTrashRemovalManager.class);
    public static final String FAST_TRASH_REMOVAL_RETENTION_RULES_DARK_FEATURE = "confluence.retention.rules.trash.fast.removal";
    private static final String FAST_TRASH_REMOVAL_SOFT_CLUSTER_LOCK_NAME = "fast_trash_removal_soft_lock";
    private static final String FAST_TRASH_REMOVAL_HARD_CLUSTER_LOCK_NAME = "fast_trash_removal_hard_lock";
    public static final String FAST_TRASH_REMOVAL_GLOBAL_TRASH_DELETE_SIZE_PER_JOB = "confluence.retention.rules.trash.fast.removal.global.trash.size";
    public static final String FAST_TRASH_REMOVAL_SPACE_TRASH_DELETE_SIZE_PER_JOB = "confluence.retention.rules.trash.fast.removal.space.trash.size";
    private final FastContentRetentionDao contentRetentionDao;
    private final FastSpaceRetentionDao spaceRetentionDao;
    private final DarkFeatureManager darkFeatureManager;

    public FastTrashRemovalManager(GlobalRetentionPolicyManager globalRetentionPolicyManager, FastTrashCleanupJobStatusManager jobStatusManager, TrashManagerInternal trashManagerInternal, PlatformTransactionManager transactionManager, RetentionFeatureChecker retentionFeatureChecker, TrashRuleEvaluator trashRuleEvaluator, EventPublisher eventPublisher, FastContentRetentionDao contentRetentionDao, FastSpaceRetentionDao spaceRetentionDao, DarkFeatureManager darkFeatureManager, ClusterLockExecutionService clusterLockExecutionService) {
        super(globalRetentionPolicyManager, jobStatusManager, trashManagerInternal, transactionManager, retentionFeatureChecker, trashRuleEvaluator, eventPublisher, clusterLockExecutionService);
        this.contentRetentionDao = Objects.requireNonNull(contentRetentionDao);
        this.spaceRetentionDao = Objects.requireNonNull(spaceRetentionDao);
        this.darkFeatureManager = Objects.requireNonNull(darkFeatureManager);
    }

    public static int globalTrashDeleteSizePerJob() {
        return Integer.getInteger(FAST_TRASH_REMOVAL_GLOBAL_TRASH_DELETE_SIZE_PER_JOB, 100);
    }

    public static int spaceTrashDeleteSizePerJob() {
        return Integer.getInteger(FAST_TRASH_REMOVAL_SPACE_TRASH_DELETE_SIZE_PER_JOB, FastTrashRemovalManager.globalTrashDeleteSizePerJob());
    }

    @Override
    public void hardRemove() {
        this.clusterLockExecutionService.doWithLock(FAST_TRASH_REMOVAL_HARD_CLUSTER_LOCK_NAME, "Fast trash hard remove", this::internalHardRemove);
    }

    @Override
    public void softRemove(int limit) {
        this.clusterLockExecutionService.doWithLock(FAST_TRASH_REMOVAL_SOFT_CLUSTER_LOCK_NAME, "Fast trash soft remove", () -> this.internalSoftRemove(limit));
    }

    @VisibleForTesting
    void internalHardRemove() {
        this.info("hard: start removing expired trashes matching your retention policies", new Object[0]);
        TrashRemovalStatisticHolder statisticHolder = new TrashRemovalStatisticHolder();
        FastTrashCleanupJobStatus jobStatus = new FastTrashCleanupJobStatus();
        do {
            this.removeTrashesOfOnePolicy(FastTrashCleanupJobStatus.GLOBAL_SPACE_ID, FastTrashRemovalManager.getBatchSize(), statisticHolder, jobStatus, false);
        } while (jobStatus.getSpaceNextStartContentId(FastTrashCleanupJobStatus.GLOBAL_SPACE_ID) != DEFAULT_CONTENT_ID_OFFSET.longValue());
        this.info("hard: completed with statistics {}", statisticHolder);
        this.eventPublisher.publish((Object)new TrashRemovalJobCompletedEvent(RemovalType.HARD, statisticHolder));
    }

    @VisibleForTesting
    void internalSoftRemove(int limit) {
        this.info("soft: start removing expired trashes matching your retention policies", new Object[0]);
        TrashRemovalStatisticHolder statisticHolder = new TrashRemovalStatisticHolder();
        FastTrashCleanupJobStatus jobStatus = (FastTrashCleanupJobStatus)this.jobStatusManager.getCurrentStatus();
        this.getAllRetentionPolicySpaceIds().forEach(policySpaceId -> this.removeTrashesOfOneSpace((Long)policySpaceId, limit, statisticHolder, jobStatus));
        this.info("soft: completed with statistics {}", statisticHolder);
        this.eventPublisher.publish((Object)new TrashRemovalJobCompletedEvent(RemovalType.SOFT, statisticHolder));
    }

    private void removeTrashesOfOneSpace(Long policySpaceId, int globalTrashDeleteSize, TrashRemovalStatisticHolder statisticHolder, FastTrashCleanupJobStatus status) {
        int spaceJobTrashDeleteSize = this.getSpaceJobTrashDeleteSize(policySpaceId, globalTrashDeleteSize);
        int cycleCount = (int)Math.ceil((double)spaceJobTrashDeleteSize / (double)FastTrashRemovalManager.getBatchSize());
        int cycleDeleteSize = Math.min(spaceJobTrashDeleteSize, FastTrashRemovalManager.getBatchSize());
        for (int i = 0; i < cycleCount; ++i) {
            this.debug("space: start with space id {}, cycle {}, cycle delete size {}", policySpaceId, cycleCount + 1, cycleDeleteSize);
            this.removeTrashesOfOnePolicy(policySpaceId, cycleDeleteSize, statisticHolder, status, true);
        }
        this.debug("space: completed with statistics {}", statisticHolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTrashesOfOnePolicy(Long policySpaceId, int deleteSize, TrashRemovalStatisticHolder statisticHolder, FastTrashCleanupJobStatus status, boolean saveJobStatus) {
        this.debug("policy: start with space id {}, delete size {}", policySpaceId, deleteSize);
        TrashRetentionRule globalRule = this.globalRetentionPolicyManager.getPolicy().getTrashRetentionRule();
        try {
            this.removeTrashContentsWithRetry(policySpaceId, globalRule, deleteSize, statisticHolder, status);
        }
        finally {
            if (saveJobStatus) {
                this.jobStatusManager.setCurrentStatus(status);
            }
        }
        this.debug("policy: completed with space id {}, statistics {}", policySpaceId, statisticHolder);
    }

    private void removeTrashContentsWithRetry(Long policySpaceId, TrashRetentionRule globalRule, int limit, TrashRemovalStatisticHolder statisticHolder, FastTrashCleanupJobStatus status) {
        long startContentId = status.getSpaceNextStartContentId(policySpaceId);
        List<Long> failedTrashIds = this.removeTrashContents(startContentId, limit, policySpaceId, globalRule, statisticHolder, status);
        if (!failedTrashIds.isEmpty()) {
            this.debug("Trash deletion in batch failed, retry deletion one by one.", new Object[0]);
            for (long trashId : failedTrashIds) {
                boolean deleted = this.removeTrashContents(trashId, 1, policySpaceId, globalRule, statisticHolder, status).isEmpty();
                if (deleted) continue;
                log.error("Error purging trash with id {}", (Object)trashId);
            }
        }
    }

    private List<Long> removeTrashContents(Long startContentId, int limit, Long policySpaceId, TrashRetentionRule globalRule, TrashRemovalStatisticHolder statisticHolder, FastTrashCleanupJobStatus jobStatus) {
        ArrayList failedTrashIds = new ArrayList();
        AtomicBoolean deletionFailed = new AtomicBoolean(false);
        try (Cleanup ignore = this.setCacheMode();){
            this.getTransactionTemplate().execute(transactionStatus -> {
                try {
                    List<SpaceContentEntityObject> trashContents = this.getTrashContents(startContentId, limit, policySpaceId);
                    List<EvaluatedTrash> evaluatedTrashes = this.trashRuleEvaluator.evaluate(globalRule, trashContents);
                    jobStatus.setSpaceNextStartContentId(policySpaceId, this.determineNextContentIdOffset(evaluatedTrashes, limit));
                    failedTrashIds.addAll(evaluatedTrashes.stream().filter(EvaluatedTrash::shouldBeDeleted).map(trash -> trash.getTrash().getId()).toList());
                    TrashRemovalStatisticThreadLocal.withStatistic(statisticHolder.getGlobalStats(), () -> this.deleteForRule(evaluatedTrashes, RuleScope.GLOBAL));
                    TrashRemovalStatisticThreadLocal.withStatistic(statisticHolder.getSpaceStats(), () -> this.deleteForRule(evaluatedTrashes, RuleScope.SPACE));
                }
                catch (Exception e) {
                    log.error("error during fast trash removal, skipping to next removal batch:", (Throwable)e);
                    deletionFailed.set(true);
                    jobStatus.setNextContentIdOffset(startContentId + (long)limit);
                    transactionStatus.setRollbackOnly();
                }
                return null;
            });
        }
        return deletionFailed.get() ? failedTrashIds : Collections.emptyList();
    }

    public boolean isEnabled() {
        return this.darkFeatureManager.isEnabledForAllUsers(FAST_TRASH_REMOVAL_RETENTION_RULES_DARK_FEATURE).orElse(false);
    }

    private List<Long> getAllRetentionPolicySpaceIds() {
        ArrayList<Long> policySpaceIds = new ArrayList<Long>(this.getSpaceRetentionPolicySpaceIds());
        policySpaceIds.add(FastTrashCleanupJobStatus.GLOBAL_SPACE_ID);
        return policySpaceIds;
    }

    private List<Long> getSpaceRetentionPolicySpaceIds() {
        List spaceIds = (List)this.getTransactionTemplate().execute(transactionStatus -> this.spaceRetentionDao.getSpaceIds());
        return Optional.ofNullable(spaceIds).orElse(Collections.emptyList());
    }

    private List<SpaceContentEntityObject> getTrashContents(Long startContentId, int limit, Long spaceId) {
        if (FastTrashCleanupJobStatus.GLOBAL_SPACE_ID.equals(spaceId)) {
            return this.contentRetentionDao.getTrashContents(startContentId, limit);
        }
        return this.contentRetentionDao.getTrashContents(startContentId, limit, spaceId);
    }

    private int getSpaceJobTrashDeleteSize(Long spaceId, int globalJobTrashDeleteSize) {
        return FastTrashCleanupJobStatus.GLOBAL_SPACE_ID.equals(spaceId) ? globalJobTrashDeleteSize : FastTrashRemovalManager.spaceTrashDeleteSizePerJob();
    }

    public void info(String format, Object ... arguments) {
        log.info("Fast trash removal - {}", (Object)format, (Object)arguments);
    }

    public void debug(String format, Object ... arguments) {
        if (log.isDebugEnabled()) {
            log.debug("Fast trash removal - {}", (Object)format, (Object)arguments);
        }
    }
}

