/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.retention.fast;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.api.model.retention.FastSoftCleanupJobStatus;
import com.atlassian.confluence.api.model.retention.GlobalRetentionPolicy;
import com.atlassian.confluence.api.model.retention.RetentionPolicy;
import com.atlassian.confluence.api.model.retention.RetentionRule;
import com.atlassian.confluence.api.model.retention.RuleScope;
import com.atlassian.confluence.api.model.retention.SoftCleanupJobStatus;
import com.atlassian.confluence.api.model.retention.SpaceRetentionPolicy;
import com.atlassian.confluence.api.service.retention.RetentionFeatureChecker;
import com.atlassian.confluence.impl.cluster.lock.ClusterLockExecutionService;
import com.atlassian.confluence.impl.retention.AbstractVersionRemovalService;
import com.atlassian.confluence.impl.retention.HistoricalVersionService;
import com.atlassian.confluence.impl.retention.VersionRemovalEventPublisher;
import com.atlassian.confluence.impl.retention.fast.dao.FastContentRetentionDao;
import com.atlassian.confluence.impl.retention.fast.dao.FastSpaceRetentionDao;
import com.atlassian.confluence.impl.retention.fast.rules.OriginalVersion;
import com.atlassian.confluence.impl.retention.fast.rules.SimpleHistoricalVersion;
import com.atlassian.confluence.impl.retention.fast.status.FastSoftCleanupStatusService;
import com.atlassian.confluence.impl.retention.rules.CleanupSummary;
import com.atlassian.confluence.impl.retention.rules.ContentType;
import com.atlassian.confluence.impl.retention.rules.DeletedHistoricalVersionSummary;
import com.atlassian.confluence.impl.retention.rules.EvaluatedHistoricalVersion;
import com.atlassian.confluence.impl.retention.rules.HistoricalVersion;
import com.atlassian.confluence.impl.retention.schedule.VersionRemovalJobType;
import com.atlassian.confluence.retention.SpaceRetentionPolicyManager;
import com.atlassian.confluence.util.Cleanup;
import com.atlassian.sal.api.features.DarkFeatureManager;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;

public class FastVersionRemovalService
extends AbstractVersionRemovalService {
    private static final Logger log = LoggerFactory.getLogger(FastVersionRemovalService.class);
    public static final String FAST_VERSION_REMOVAL_DARK_FEATURE = "confluence.retention.rules.version.fast.removal";
    public static final String FAST_VERSION_REMOVAL_SQL_SELECT_LIMIT = "confluence.retention.rules.version.fast.removal.sql.select.limit";
    public static final String FAST_VERSION_REMOVAL_GLOBAL_ORIGINAL_PAGE_SIZE_PER_JOB = "confluence.retention.rules.content.fast.removal.global.original.page.size";
    public static final String FAST_VERSION_REMOVAL_SPACE_ORIGINAL_PAGE_SIZE_PER_JOB = "confluence.retention.rules.content.fast.removal.space.original.page.size";
    private static final String FAST_VERSION_REMOVAL_SOFT_CLUSTER_LOCK_NAME = "fast_version_removal_soft_lock";
    private static final String FAST_VERSION_REMOVAL_HARD_CLUSTER_LOCK_NAME = "fast_version_removal_hard_lock";
    private final FastContentRetentionDao contentRetentionDao;
    private final FastSpaceRetentionDao spaceRetentionDao;
    private final DarkFeatureManager darkFeatureManager;

    public FastVersionRemovalService(HistoricalVersionService historicalVersionService, FastSoftCleanupStatusService softCleanupStatusService, VersionRemovalEventPublisher versionRemovalEventPublisher, PlatformTransactionManager transactionManager, RetentionFeatureChecker retentionFeatureChecker, SpaceRetentionPolicyManager spaceRetentionPolicyManager, FastContentRetentionDao contentRetentionDao, FastSpaceRetentionDao spaceRetentionDao, DarkFeatureManager darkFeatureManager, ClusterLockExecutionService clusterLockExecutionService) {
        super(historicalVersionService, softCleanupStatusService, versionRemovalEventPublisher, transactionManager, retentionFeatureChecker, spaceRetentionPolicyManager, clusterLockExecutionService);
        this.contentRetentionDao = Objects.requireNonNull(contentRetentionDao);
        this.spaceRetentionDao = Objects.requireNonNull(spaceRetentionDao);
        this.darkFeatureManager = Objects.requireNonNull(darkFeatureManager);
    }

    public boolean isEnabled() {
        return this.darkFeatureManager.isEnabledForAllUsers(FAST_VERSION_REMOVAL_DARK_FEATURE).orElse(false);
    }

    public static int sqlSelectLimit() {
        return Integer.getInteger(FAST_VERSION_REMOVAL_SQL_SELECT_LIMIT, 1000);
    }

    public static int globalOriginalPageSizePerJob() {
        return Integer.getInteger(FAST_VERSION_REMOVAL_GLOBAL_ORIGINAL_PAGE_SIZE_PER_JOB, 1000);
    }

    public static int spaceOriginalPageSizePerJob() {
        return Integer.getInteger(FAST_VERSION_REMOVAL_SPACE_ORIGINAL_PAGE_SIZE_PER_JOB, FastVersionRemovalService.globalOriginalPageSizePerJob());
    }

    @Override
    public void hardRemoveVersions(RetentionPolicy policy) {
        this.clusterLockExecutionService.doWithLock(FAST_VERSION_REMOVAL_HARD_CLUSTER_LOCK_NAME, "Fast version hard remove", () -> this.internalHardRemoveVersions(policy));
    }

    @Override
    public void softRemoveVersions(RetentionPolicy policy, int batchSize) {
        this.clusterLockExecutionService.doWithLock(FAST_VERSION_REMOVAL_SOFT_CLUSTER_LOCK_NAME, "Fast version soft remove", () -> this.internalSoftRemoveVersions(policy, batchSize));
    }

    @VisibleForTesting
    void internalHardRemoveVersions(RetentionPolicy globalPolicy) {
        this.info("hard: begin with select limit size {}", FastVersionRemovalService.sqlSelectLimit());
        FastSoftCleanupJobStatus jobStatus = new FastSoftCleanupJobStatus.FastSoftCleanupJobStatusBuilder().build();
        CleanupSummary jobCleanupSummary = CleanupSummary.createDefault();
        List<Long> allPolicySpaceIds = this.getAllRetentionPolicySpaceIds();
        for (long spaceId : allPolicySpaceIds) {
            CleanupSummary spaceCleanupSummary = this.removeAllExpiredVersionsOfOneSpace(spaceId, globalPolicy, jobStatus, allPolicySpaceIds);
            jobCleanupSummary = this.concatSummaries(jobCleanupSummary, spaceCleanupSummary);
        }
        this.info("hard: completed with summary {}", jobCleanupSummary);
        this.versionRemovalEventPublisher.publishJobCompletedEvent(jobCleanupSummary, VersionRemovalJobType.HARD);
    }

    @VisibleForTesting
    void internalSoftRemoveVersions(RetentionPolicy globalPolicy, int globalJobSize) {
        this.info("soft: start with global job size {}", globalJobSize);
        FastSoftCleanupJobStatus jobStatus = (FastSoftCleanupJobStatus)this.softCleanupStatusService.getCurrentStatus();
        CleanupSummary jobCleanupSummary = CleanupSummary.createDefault();
        List<Long> allPolicySpaceIds = this.getAllRetentionPolicySpaceIds();
        for (long spaceId : allPolicySpaceIds) {
            CleanupSummary spaceCleanupSummary = this.removeLimitedExpiredVersionsOfOneSpace(spaceId, globalPolicy, globalJobSize, jobStatus, allPolicySpaceIds);
            jobCleanupSummary = this.concatSummaries(jobCleanupSummary, spaceCleanupSummary);
        }
        this.info("soft: completed with summary {}", jobCleanupSummary);
        this.versionRemovalEventPublisher.publishJobCompletedEvent(jobCleanupSummary, VersionRemovalJobType.SOFT);
    }

    private CleanupSummary removeAllExpiredVersionsOfOneSpace(Long policySpaceId, RetentionPolicy globalPolicy, FastSoftCleanupJobStatus jobStatus, List<Long> allPolicySpaceIds) {
        this.debug("space: start with space id {}", policySpaceId);
        CleanupSummary spaceCleanupSummary = CleanupSummary.createDefault();
        RetentionPolicy policy = FastSoftCleanupJobStatus.GLOBAL_SPACE_ID.equals(policySpaceId) ? globalPolicy : (RetentionPolicy)this.spaceRetentionPolicyManager.getPolicy(policySpaceId.longValue()).orElse(null);
        policy = this.copyRetentionPolicy(policy);
        if (policy == null) {
            return spaceCleanupSummary;
        }
        boolean pageRemoveCompleted = false;
        boolean attachmentRemoveCompleted = false;
        do {
            CleanupSummary policyCleanupSummary = this.removeExpiredVersionsOfOnePolicy(policy, policySpaceId, jobStatus, allPolicySpaceIds, FastVersionRemovalService.sqlSelectLimit(), false);
            spaceCleanupSummary = this.concatSummaries(spaceCleanupSummary, policyCleanupSummary);
            if (jobStatus.getSpacePageNextStartOriginalId(policySpaceId.longValue()) == DEFAULT_START_ORIGINAL_ID.longValue()) {
                pageRemoveCompleted = true;
                policy.getPageVersionRule().setKeepAll(true);
            }
            if (jobStatus.getSpaceAttachmentNextStartOriginalId(policySpaceId.longValue()) != DEFAULT_START_ORIGINAL_ID.longValue()) continue;
            attachmentRemoveCompleted = true;
            policy.getAttachmentRetentionRule().setKeepAll(true);
        } while (!pageRemoveCompleted || !attachmentRemoveCompleted);
        this.debug("space: completed with space id {}, summary {}", policySpaceId, spaceCleanupSummary);
        return spaceCleanupSummary;
    }

    private CleanupSummary removeLimitedExpiredVersionsOfOneSpace(Long policySpaceId, RetentionPolicy globalPolicy, int globalJobSize, FastSoftCleanupJobStatus jobStatus, List<Long> allPolicySpaceIds) {
        RetentionPolicy policy;
        this.debug("space: start with space id {}", policySpaceId);
        CleanupSummary cycleCleanupSummary = CleanupSummary.createDefault();
        int spaceJobSize = this.getSpaceJobSize(policySpaceId, globalJobSize);
        int cycleCount = (int)Math.ceil((double)spaceJobSize / (double)FastVersionRemovalService.sqlSelectLimit());
        int sqlSelectLimit = Math.min(spaceJobSize, FastVersionRemovalService.sqlSelectLimit());
        RetentionPolicy retentionPolicy = policy = FastSoftCleanupJobStatus.GLOBAL_SPACE_ID.equals(policySpaceId) ? globalPolicy : (RetentionPolicy)this.spaceRetentionPolicyManager.getPolicy(policySpaceId.longValue()).orElse(null);
        if (policy == null) {
            return cycleCleanupSummary;
        }
        for (int i = 0; i < cycleCount; ++i) {
            this.debug("space: start with space id {}, cycle {}, select limit {}", policySpaceId, cycleCount + 1, sqlSelectLimit);
            CleanupSummary loopCleanupSummary = this.removeExpiredVersionsOfOnePolicy(policy, policySpaceId, jobStatus, allPolicySpaceIds, sqlSelectLimit, true);
            cycleCleanupSummary = this.concatSummaries(cycleCleanupSummary, loopCleanupSummary);
        }
        this.debug("space: completed with space id {}, summary {}", policySpaceId, cycleCleanupSummary);
        return cycleCleanupSummary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CleanupSummary removeExpiredVersionsOfOnePolicy(RetentionPolicy policy, Long policySpaceId, FastSoftCleanupJobStatus jobStatus, List<Long> allPolicySpaceIds, int sqlSelectLimit, boolean saveJobStatus) {
        this.debug("policy: start with space id {}, select limit {}, policy {}", policySpaceId, sqlSelectLimit, policy);
        CleanupSummary policyCleanupSummary = CleanupSummary.createDefault();
        try (Cleanup ignore = this.setCacheMode();){
            CleanupSummary pageCleanupSummary = this.removeExpiredPageVersionsOfOnePolicy(policy, sqlSelectLimit, policySpaceId, allPolicySpaceIds, jobStatus);
            CleanupSummary attachmentCleanupSummary = this.removeExpiredAttachmentVersionsOfOnePolicy(policy, sqlSelectLimit, policySpaceId, allPolicySpaceIds, jobStatus);
            policyCleanupSummary = this.concatSummaries(pageCleanupSummary, attachmentCleanupSummary);
        }
        finally {
            if (saveJobStatus) {
                this.saveJobStatus((SoftCleanupJobStatus)jobStatus);
            }
        }
        this.debug("policy: completed with space id {}, select limit {}, policy {}, summary {}", policySpaceId, sqlSelectLimit, policy, policyCleanupSummary);
        return policyCleanupSummary;
    }

    private CleanupSummary removeExpiredPageVersionsOfOnePolicy(RetentionPolicy policy, int sqlSelectLimit, Long policySpaceId, List<Long> allPolicySpaceIds, FastSoftCleanupJobStatus jobStatus) {
        CleanupSummary cleanupSummary = CleanupSummary.createDefault();
        long startOriginalId = jobStatus.getSpacePageNextStartOriginalId(policySpaceId.longValue());
        try {
            cleanupSummary = this.removeExpiredVersionsOfOneRule(policy.getPageVersionRule(), startOriginalId, sqlSelectLimit, ContentType.PAGE, policySpaceId, allPolicySpaceIds);
            jobStatus.setSpacePageNextStartOriginalId(policySpaceId.longValue(), cleanupSummary.getNextStartOriginalId());
        }
        catch (Exception ex) {
            log.error("error during fast version page removal, skipping to next removal batch:", (Throwable)ex);
            jobStatus.setSpacePageNextStartOriginalId(policySpaceId.longValue(), startOriginalId + (long)sqlSelectLimit);
        }
        return cleanupSummary;
    }

    private CleanupSummary removeExpiredAttachmentVersionsOfOnePolicy(RetentionPolicy policy, int sqlSelectLimit, Long policySpaceId, List<Long> allPolicySpaceIds, FastSoftCleanupJobStatus jobStatus) {
        CleanupSummary cleanupSummary = CleanupSummary.createDefault();
        long startOriginalId = jobStatus.getSpaceAttachmentNextStartOriginalId(policySpaceId.longValue());
        try {
            cleanupSummary = this.removeExpiredVersionsOfOneRule(policy.getAttachmentRetentionRule(), startOriginalId, sqlSelectLimit, ContentType.ATTACHMENT, policySpaceId, allPolicySpaceIds);
            jobStatus.setSpaceAttachmentNextStartOriginalId(policySpaceId.longValue(), cleanupSummary.getNextStartOriginalId());
        }
        catch (Exception ex) {
            log.error("error fast version attachment removal", (Throwable)ex);
            jobStatus.setSpaceAttachmentNextStartOriginalId(policySpaceId.longValue(), startOriginalId + (long)sqlSelectLimit);
        }
        return cleanupSummary;
    }

    private CleanupSummary removeExpiredVersionsOfOneRule(RetentionRule rule, long startOriginalId, int sqlSelectLimit, ContentType contentType, Long ruleSpaceId, List<Long> policySpaceIds) {
        this.debug("rule: start with space id {}, type {}, start original id {}, select limit {}, rule {}", new Object[]{ruleSpaceId, contentType, startOriginalId, sqlSelectLimit, rule});
        if (rule.getKeepAll()) {
            return CleanupSummary.createDefault();
        }
        List<OriginalVersion> originalVersions = this.getOriginalVersions(contentType, startOriginalId, ruleSpaceId, sqlSelectLimit);
        boolean isLastTableCycle = originalVersions.size() < sqlSelectLimit;
        long lastOriginalVersionIdProcessed = originalVersions.isEmpty() ? DEFAULT_START_ORIGINAL_ID.longValue() : Collections.max(originalVersions.stream().map(OriginalVersion::getId).toList()).longValue();
        long nextStartOriginalId = isLastTableCycle ? DEFAULT_START_ORIGINAL_ID : lastOriginalVersionIdProcessed + 1L;
        CleanupSummary ruleCleanupSummary = new CleanupSummary.Builder().lastIdProcessed(lastOriginalVersionIdProcessed).nextStartOriginalId(nextStartOriginalId).build();
        if (FastSoftCleanupJobStatus.GLOBAL_SPACE_ID.equals(ruleSpaceId)) {
            originalVersions = originalVersions.stream().filter(ov -> !policySpaceIds.contains(ov.getSpaceId())).toList();
        }
        if (originalVersions.isEmpty()) {
            return ruleCleanupSummary;
        }
        CleanupSummary removedCleanupSummary = this.removeExpiredVersionsOfOriginalVersions(rule, originalVersions, sqlSelectLimit, contentType, ruleSpaceId);
        ruleCleanupSummary = this.concatSummaries(removedCleanupSummary, ruleCleanupSummary);
        this.debug("rule: completed with space id {}, type {}, start original id {}, select limit {}, rule {}, summary {}", new Object[]{ruleSpaceId, contentType, startOriginalId, sqlSelectLimit, rule, ruleCleanupSummary});
        return ruleCleanupSummary;
    }

    private CleanupSummary removeExpiredVersionsOfOriginalVersions(RetentionRule rule, List<OriginalVersion> originalVersions, int sqlSelectLimit, ContentType contentType, Long ruleSpaceId) {
        List<Long> originalVersionIds = originalVersions.stream().map(OriginalVersion::getId).toList();
        HashMap<Long, Long> originalVersionSpaceIds = new HashMap<Long, Long>();
        originalVersions.forEach(ov -> originalVersionSpaceIds.put(ov.getId(), ov.getSpaceId()));
        RuleScope ruleScope = FastSoftCleanupJobStatus.GLOBAL_SPACE_ID.equals(ruleSpaceId) ? RuleScope.GLOBAL : RuleScope.SPACE;
        CleanupSummary totalCleanupSummary = CleanupSummary.createDefault();
        int ruleLoopCount = 1;
        Long startVersionId = null;
        while (true) {
            this.debug("original versions: start with loop {}, space id {}, type {}, rule {}", new Object[]{ruleLoopCount, ruleSpaceId, contentType, rule});
            List<SimpleHistoricalVersion> historicalVersions = this.getHistoricalVersions(contentType, originalVersionIds, sqlSelectLimit, rule, startVersionId);
            startVersionId = historicalVersions.isEmpty() ? null : Long.valueOf(Collections.max(historicalVersions.stream().map(SimpleHistoricalVersion::getId).toList()) + 1L);
            List<EvaluatedHistoricalVersion> evaluatedVersions = this.evaluate(historicalVersions, originalVersionSpaceIds, ruleScope);
            List<DeletedHistoricalVersionSummary> deletedSummaryList = this.deleteForRule(evaluatedVersions, ruleScope);
            CleanupSummary loopCleanupSummary = this.generateCleanupSummary(deletedSummaryList, ruleScope);
            totalCleanupSummary = this.concatSummaries(totalCleanupSummary, loopCleanupSummary);
            if (historicalVersions.isEmpty()) break;
            ++ruleLoopCount;
        }
        return totalCleanupSummary;
    }

    private List<EvaluatedHistoricalVersion> evaluate(List<SimpleHistoricalVersion> historicalVersions, Map<Long, Long> originalVersionSpaceIds, RuleScope ruleScope) {
        return historicalVersions.stream().map(hv -> {
            Long spaceId = (Long)originalVersionSpaceIds.get(hv.getOriginalId());
            HistoricalVersion historicalVersion = new HistoricalVersion(hv.getId(), hv.getOriginalId(), spaceId, hv.getVersion(), hv.getLastModificationDate(), hv.getContentType());
            return new EvaluatedHistoricalVersion(historicalVersion, ruleScope, true);
        }).toList();
    }

    private List<Long> getSpaceRetentionPolicySpaceIds() {
        return (List)this.getTransactionTemplate().execute(transactionStatus -> this.spaceRetentionDao.getSpaceIds());
    }

    private List<Long> getAllRetentionPolicySpaceIds() {
        ArrayList<Long> policySpaceIds = new ArrayList<Long>(this.getSpaceRetentionPolicySpaceIds());
        policySpaceIds.add(FastSoftCleanupJobStatus.GLOBAL_SPACE_ID);
        return policySpaceIds;
    }

    private List<OriginalVersion> getOriginalVersions(ContentType contentType, long startOriginalId, long ruleSpaceId, int sqlSelectLimit) {
        return (List)this.getTransactionTemplate().execute(transactionStatus -> {
            if (FastSoftCleanupJobStatus.GLOBAL_SPACE_ID.equals(ruleSpaceId)) {
                return this.contentRetentionDao.getOriginalVersions(contentType, startOriginalId, sqlSelectLimit);
            }
            return this.contentRetentionDao.getOriginalVersions(contentType, startOriginalId, ruleSpaceId, sqlSelectLimit);
        });
    }

    private List<SimpleHistoricalVersion> getHistoricalVersions(ContentType contentType, List<Long> originalVersionIds, int sqlSelectLimit, RetentionRule rule, @Nullable Long startVersionId) {
        return (List)this.getTransactionTemplate().execute(transactionStatus -> {
            if (rule.hasVersionLimit()) {
                return this.contentRetentionDao.getHistoricalVersionsByMaxVersion(contentType, originalVersionIds, sqlSelectLimit, rule.getMaxNumberOfVersions(), startVersionId);
            }
            if (rule.hasAgeLimit()) {
                ZonedDateTime maxModifiedDate = rule.calculateMaxDate(LocalDate.now()).atStartOfDay().atZone(ZoneId.systemDefault());
                return this.contentRetentionDao.getHistoricalVersionsByMaxModifiedDate(contentType, originalVersionIds, sqlSelectLimit, maxModifiedDate, startVersionId);
            }
            return Collections.emptyList();
        });
    }

    private CleanupSummary generateCleanupSummary(List<DeletedHistoricalVersionSummary> deletedSummaryList, RuleScope ruleScope) {
        CleanupSummary.Builder builder = new CleanupSummary.Builder();
        long pageVersionsRemoved = deletedSummaryList.stream().filter(Objects::nonNull).mapToLong(DeletedHistoricalVersionSummary::getPageVersionsRemoved).sum();
        long attachmentVersionsRemoved = deletedSummaryList.stream().filter(Objects::nonNull).mapToLong(DeletedHistoricalVersionSummary::getAttachmentVersionsRemoved).sum();
        long attachmentSizeRemoved = deletedSummaryList.stream().filter(Objects::nonNull).mapToLong(DeletedHistoricalVersionSummary::getAttachmentSizeRemoved).sum();
        if (ruleScope == RuleScope.GLOBAL) {
            builder.pageVersionsRemovedByGlobalRules(pageVersionsRemoved).attachmentVersionsRemovedByGlobalRules(attachmentVersionsRemoved).attachmentSizeRemovedByGlobalRules(attachmentSizeRemoved);
        } else {
            builder.pageVersionsRemovedBySpaceRules(pageVersionsRemoved).attachmentVersionsRemovedBySpaceRules(attachmentVersionsRemoved).attachmentSizeRemovedBySpaceRules(attachmentSizeRemoved);
        }
        return builder.build();
    }

    private CleanupSummary concatSummaries(CleanupSummary oldSummary, CleanupSummary newSummary) {
        return new CleanupSummary.Builder().attachmentVersionsRemovedByGlobalRules(oldSummary.getAttachmentVersionsRemovedByGlobalRules() + newSummary.getAttachmentVersionsRemovedByGlobalRules()).attachmentVersionsRemovedBySpaceRules(oldSummary.getAttachmentVersionsRemovedBySpaceRules() + newSummary.getAttachmentVersionsRemovedBySpaceRules()).pageVersionsRemovedByGlobalRules(oldSummary.getPageVersionsRemovedByGlobalRules() + newSummary.getPageVersionsRemovedByGlobalRules()).pageVersionsRemovedBySpaceRules(oldSummary.getPageVersionsRemovedBySpaceRules() + newSummary.getPageVersionsRemovedBySpaceRules()).attachmentSizeRemovedByGlobalRules(newSummary.getAttachmentSizeRemovedByGlobalRules()).attachmentSizeRemovedBySpaceRules(newSummary.getAttachmentSizeRemovedBySpaceRules()).lastIdProcessed(newSummary.getLastIdProcessed()).nextStartOriginalId(newSummary.getNextStartOriginalId()).build();
    }

    private RetentionPolicy copyRetentionPolicy(RetentionPolicy policy) {
        if (policy instanceof GlobalRetentionPolicy) {
            return new GlobalRetentionPolicy.GlobalRetentionPolicyBuilder().pageRetentionRule(policy.getPageVersionRule()).attachmentRetentionRule(policy.getAttachmentRetentionRule()).build();
        }
        if (policy instanceof SpaceRetentionPolicy) {
            return new SpaceRetentionPolicy.Builder().pageRetentionRule(policy.getPageVersionRule()).attachmentRetentionRule(policy.getAttachmentRetentionRule()).build();
        }
        return null;
    }

    private int getSpaceJobSize(Long spaceId, int globalJobSize) {
        return FastSoftCleanupJobStatus.GLOBAL_SPACE_ID.equals(spaceId) ? globalJobSize : FastVersionRemovalService.spaceOriginalPageSizePerJob();
    }

    public void info(String format, Object ... arguments) {
        log.info("Fast version removal - {}", (Object)format, (Object)arguments);
    }

    public void debug(String format, Object ... arguments) {
        if (log.isDebugEnabled()) {
            log.debug("Fast version removal - {}", (Object)format, (Object)arguments);
        }
    }
}

