/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.retention.fast.dao;

import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.impl.retention.fast.dao.FastContentRetentionDao;
import com.atlassian.confluence.impl.retention.fast.rules.OriginalVersion;
import com.atlassian.confluence.impl.retention.fast.rules.SimpleHistoricalVersion;
import com.atlassian.confluence.impl.retention.rules.ContentType;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.Page;
import jakarta.persistence.Tuple;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.SessionFactory;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class DefaultFastContentRetentionDao
implements FastContentRetentionDao {
    private static final String ID = "id";
    private static final String SPACE_ID = "spaceId";
    private static final String CONTENT_TYPE = "contentType";
    private static final String START_ORIGINAL_ID = "startOriginalId";
    private static final String MAX_VERSION_TO_KEEP = "maxVersionToKeep";
    private static final String START_VERSION_ID = "startVersionId";
    private static final String MAX_LAST_MODIFIED_DATE = "maxLastModifiedDate";
    private static final String LAST_MODIFICATION_DATE = "lastModificationDate";
    private static final String VERSION = "version";
    private static final String ORIGINAL_IDS = "originalIds";
    private static final String ORIGINAL_ID = "originalId";
    static final String SELECT_ORIGINAL_VERSIONS = "SELECT new com.atlassian.confluence.impl.retention.fast.rules.OriginalVersion(ov.id, ov.space.id) FROM ContentEntityObject ov WHERE type(ov) = :contentType AND ov.originalVersion IS NULL AND ov.id >= :startOriginalId AND ov.contentStatus = 'current' ORDER BY ov.id ASC";
    static final String SELECT_ORIGINAL_VERSIONS_WITH_SPACE_ID = "SELECT new com.atlassian.confluence.impl.retention.fast.rules.OriginalVersion(ov.id, ov.space.id) FROM ContentEntityObject ov WHERE type(ov) = :contentType AND ov.originalVersion IS NULL AND ov.id >= :startOriginalId AND ov.contentStatus = 'current' AND ov.space.id = :spaceId ORDER BY ov.id ASC";
    static final String SELECT_HISTORICAL_VERSIONS_BY_VERSION = "SELECT ranked.id, ranked.originalId, ranked.version, ranked.lastModificationDate FROM (    SELECT ct.CONTENTID AS id, ct.PREVVER AS originalId, ct.VERSION AS version, ct.LASTMODDATE as lastModificationDate,           ROW_NUMBER() OVER (PARTITION BY ct.PREVVER ORDER BY VERSION DESC) AS rowNumber    FROM CONTENT ct    WHERE ct.CONTENTTYPE = :contentType    AND ct.PREVVER IN (:originalIds)    AND ct.CONTENT_STATUS = 'current') ranked WHERE ranked.rowNumber > :maxVersionToKeep AND ranked.id >= :startVersionId ORDER BY ranked.id ASC";
    static final String SELECT_HISTORICAL_VERSIONS_BY_LAST_MODIFIED_DATE = "SELECT ct.CONTENTID AS id, ct.PREVVER AS originalId, ct.VERSION AS version, ct.LASTMODDATE as lastModificationDate FROM CONTENT ct WHERE ct.CONTENTTYPE = :contentType AND ct.PREVVER IN (:originalIds) AND ct.CONTENT_STATUS = 'current' AND ct.LASTMODDATE IS NOT NULL AND ct.LASTMODDATE < :maxLastModifiedDate AND ct.CONTENTID >= :startVersionId ORDER BY ct.CONTENTID ASC";
    static final String SELECT_TRASH_CONTENTS = "SELECT ct FROM SpaceContentEntityObject ct WHERE ct.contentStatus = 'deleted' AND ct.id >= :startContentId AND ct.originalVersion IS NULL ORDER BY ct.id ASC";
    static final String SELECT_TRASH_CONTENTS_WITH_SPACE_ID = "SELECT ct FROM SpaceContentEntityObject ct WHERE ct.space.id = :spaceId AND ct.contentStatus = 'deleted' AND ct.id >= :startContentId AND ct.originalVersion IS NULL ORDER BY ct.id ASC";
    private final SessionFactory sessionFactory;

    public DefaultFastContentRetentionDao(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public List<OriginalVersion> getOriginalVersions(ContentType contentType, long startOriginalId, int limit) {
        Query<OriginalVersion> query = this.createQueryForOriginalVersions(SELECT_ORIGINAL_VERSIONS, contentType, startOriginalId, limit);
        return query.list();
    }

    @Override
    public List<OriginalVersion> getOriginalVersions(ContentType contentType, long startOriginalId, long spaceId, int limit) {
        Query query = this.createQueryForOriginalVersions(SELECT_ORIGINAL_VERSIONS_WITH_SPACE_ID, contentType, startOriginalId, limit).setParameter(SPACE_ID, (Object)spaceId);
        return query.list();
    }

    @Override
    public List<SimpleHistoricalVersion> getHistoricalVersionsByMaxVersion(ContentType contentType, List<Long> originalIds, int limit, int maxVersionToKeep, @Nullable Long startVersionId) {
        NativeQuery query = this.createQueryForHistoricalVersions(SELECT_HISTORICAL_VERSIONS_BY_VERSION, contentType, originalIds, limit, startVersionId).setParameter(MAX_VERSION_TO_KEEP, (Object)maxVersionToKeep);
        return query.list().stream().map(tuple -> this.mapHistoricalVersion((Tuple)tuple, contentType)).toList();
    }

    @Override
    public List<SimpleHistoricalVersion> getHistoricalVersionsByMaxModifiedDate(ContentType contentType, List<Long> originalIds, int limit, ZonedDateTime maxModifiedDate, @Nullable Long startVersionId) {
        NativeQuery query = this.createQueryForHistoricalVersions(SELECT_HISTORICAL_VERSIONS_BY_LAST_MODIFIED_DATE, contentType, originalIds, limit, startVersionId).setParameter(MAX_LAST_MODIFIED_DATE, (Object)maxModifiedDate.withZoneSameInstant(ZoneOffset.UTC));
        return query.list().stream().map(tuple -> this.mapHistoricalVersion((Tuple)tuple, contentType)).toList();
    }

    @Override
    public List<SpaceContentEntityObject> getTrashContents(long startContentId, int limit) {
        Query query = this.sessionFactory.getCurrentSession().createQuery(SELECT_TRASH_CONTENTS, SpaceContentEntityObject.class);
        query.setParameter("startContentId", (Object)startContentId);
        query.setMaxResults(limit);
        return query.getResultList();
    }

    @Override
    public List<SpaceContentEntityObject> getTrashContents(long startContentId, int limit, Long spaceId) {
        Query query = this.sessionFactory.getCurrentSession().createQuery(SELECT_TRASH_CONTENTS_WITH_SPACE_ID, SpaceContentEntityObject.class);
        query.setParameter("startContentId", (Object)startContentId);
        query.setParameter(SPACE_ID, (Object)spaceId);
        query.setMaxResults(limit);
        return query.getResultList();
    }

    private Query<OriginalVersion> createQueryForOriginalVersions(String sql, ContentType contentType, long startOriginalId, int limit) {
        Query query = this.sessionFactory.getCurrentSession().createQuery(sql, OriginalVersion.class);
        query.setParameter(CONTENT_TYPE, contentType.equals((Object)ContentType.PAGE) ? Page.class : Attachment.class);
        query.setParameter(START_ORIGINAL_ID, (Object)startOriginalId);
        query.setMaxResults(limit);
        return query;
    }

    private NativeQuery<Tuple> createQueryForHistoricalVersions(String sql, ContentType contentType, List<Long> originalIds, int limit, @Nullable Long startVersionId) {
        NativeQuery query = this.sessionFactory.getCurrentSession().createNativeQuery(sql, Tuple.class);
        query.addScalar(ID, (Type)StandardBasicTypes.LONG);
        query.addScalar(ORIGINAL_ID, (Type)StandardBasicTypes.LONG);
        query.addScalar(VERSION, (Type)StandardBasicTypes.INTEGER);
        query.addScalar(LAST_MODIFICATION_DATE, (Type)StandardBasicTypes.TIMESTAMP);
        query.setParameter(CONTENT_TYPE, (Object)contentType.name());
        query.setParameterList(ORIGINAL_IDS, originalIds);
        query.setParameter(START_VERSION_ID, (Object)Optional.ofNullable(startVersionId).orElse(0L));
        query.setMaxResults(limit);
        return query;
    }

    private SimpleHistoricalVersion mapHistoricalVersion(Tuple tuple, ContentType contentType) {
        return new SimpleHistoricalVersion((Long)tuple.get(ID), (Long)tuple.get(ORIGINAL_ID), (Integer)tuple.get(VERSION), (Date)tuple.get(LAST_MODIFICATION_DATE), contentType.name());
    }
}

