/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.retention.listener;

import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.event.events.retention.SpaceRetentionPolicyChangedEvent;
import com.atlassian.confluence.event.events.retention.SpaceRetentionPolicyCreatedEvent;
import com.atlassian.confluence.event.events.retention.SpaceRetentionPolicyDeletedEvent;
import com.atlassian.confluence.impl.event.RegisterEventListeners;
import com.atlassian.confluence.search.ConfluenceIndexer;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceDescription;
import com.atlassian.event.api.EventListener;
import java.util.Objects;

@RegisterEventListeners
public class SpaceRetentionPolicyIndexingListener {
    private final ConfluenceIndexer confluenceIndexer;

    public SpaceRetentionPolicyIndexingListener(ConfluenceIndexer confluenceIndexer) {
        this.confluenceIndexer = Objects.requireNonNull(confluenceIndexer);
    }

    @EventListener
    public void policyCreated(SpaceRetentionPolicyCreatedEvent createdEvent) {
        this.reindex(createdEvent.getSpace());
    }

    @EventListener
    public void policyChanged(SpaceRetentionPolicyChangedEvent changedEvent) {
        this.reindex(changedEvent.getSpace());
    }

    @EventListener
    public void policyDeleted(SpaceRetentionPolicyDeletedEvent deletedEvent) {
        this.reindex(deletedEvent.getSpace());
    }

    private void reindex(Space space) {
        SpaceDescription spaceDescription = space.getDescription();
        this.confluenceIndexer.reIndex((Searchable)spaceDescription);
    }
}

