/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.retention.manager;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.api.model.retention.RuleScope;
import com.atlassian.confluence.api.service.retention.RetentionFeatureChecker;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.core.persistence.hibernate.CacheMode;
import com.atlassian.confluence.core.persistence.hibernate.SessionCacheModeThreadLocal;
import com.atlassian.confluence.dmz.pages.TrashManagerInternal;
import com.atlassian.confluence.impl.cluster.lock.ClusterLockExecutionService;
import com.atlassian.confluence.impl.retention.manager.GlobalRetentionPolicyManager;
import com.atlassian.confluence.impl.retention.manager.TrashRemovalManager;
import com.atlassian.confluence.impl.retention.rules.EvaluatedTrash;
import com.atlassian.confluence.impl.retention.rules.TrashRuleEvaluator;
import com.atlassian.confluence.impl.retention.status.TrashCleanupJobStatusManager;
import com.atlassian.confluence.util.Cleanup;
import com.atlassian.event.api.EventPublisher;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public abstract class AbstractTrashRemovalManager
implements TrashRemovalManager {
    private static final Logger log = LoggerFactory.getLogger(AbstractTrashRemovalManager.class);
    public static final Long DEFAULT_CONTENT_ID_OFFSET = 0L;
    public static final String TRASH_REMOVAL_DELETE_BATCH_SIZE = "confluence.trash.retention.batch.size";
    protected final GlobalRetentionPolicyManager globalRetentionPolicyManager;
    protected final TrashCleanupJobStatusManager jobStatusManager;
    protected final TrashManagerInternal trashManagerInternal;
    protected final PlatformTransactionManager transactionManager;
    protected final RetentionFeatureChecker retentionFeatureChecker;
    protected final TrashRuleEvaluator trashRuleEvaluator;
    protected final EventPublisher eventPublisher;
    protected final ClusterLockExecutionService clusterLockExecutionService;

    public AbstractTrashRemovalManager(GlobalRetentionPolicyManager globalRetentionPolicyManager, TrashCleanupJobStatusManager jobStatusManager, TrashManagerInternal trashManagerInternal, PlatformTransactionManager transactionManager, RetentionFeatureChecker retentionFeatureChecker, TrashRuleEvaluator trashRuleEvaluator, EventPublisher eventPublisher, ClusterLockExecutionService clusterLockExecutionService) {
        this.globalRetentionPolicyManager = Objects.requireNonNull(globalRetentionPolicyManager);
        this.jobStatusManager = Objects.requireNonNull(jobStatusManager);
        this.trashManagerInternal = Objects.requireNonNull(trashManagerInternal);
        this.transactionManager = Objects.requireNonNull(transactionManager);
        this.retentionFeatureChecker = Objects.requireNonNull(retentionFeatureChecker);
        this.trashRuleEvaluator = Objects.requireNonNull(trashRuleEvaluator);
        this.eventPublisher = Objects.requireNonNull(eventPublisher);
        this.clusterLockExecutionService = Objects.requireNonNull(clusterLockExecutionService);
    }

    public static int getBatchSize() {
        return Integer.getInteger(TRASH_REMOVAL_DELETE_BATCH_SIZE, 100);
    }

    @VisibleForTesting
    protected void deleteForRule(List<EvaluatedTrash> evaluatedTrashes, RuleScope ruleScope) {
        List<SpaceContentEntityObject> toDelete = evaluatedTrashes.stream().filter(evaluatedTrash -> evaluatedTrash.shouldBeDeleted() && evaluatedTrash.getRuleScope() == ruleScope).map(EvaluatedTrash::getTrash).toList();
        if (this.retentionFeatureChecker.isDryRunModeEnabled()) {
            toDelete.forEach(this::logDeletedTrash);
        } else if (!toDelete.isEmpty()) {
            this.trashManagerInternal.purge(toDelete);
            this.logDeletedTrashes(toDelete);
        }
    }

    protected long determineNextContentIdOffset(List<EvaluatedTrash> evaluatedTrashes, int batchSize) {
        return evaluatedTrashes.size() == batchSize ? evaluatedTrashes.get(evaluatedTrashes.size() - 1).getTrash().getId() + 1L : DEFAULT_CONTENT_ID_OFFSET;
    }

    protected TransactionTemplate getTransactionTemplate() {
        TransactionTemplate transactionTemplate = new TransactionTemplate(this.transactionManager);
        transactionTemplate.setPropagationBehavior(3);
        transactionTemplate.setIsolationLevel(-1);
        transactionTemplate.setName("TrashRemovalService");
        return transactionTemplate;
    }

    protected Cleanup setCacheMode() {
        return SessionCacheModeThreadLocal.temporarilySetCacheMode((CacheMode)CacheMode.IGNORE);
    }

    private void logDeletedTrashes(List<SpaceContentEntityObject> trashes) {
        if (log.isDebugEnabled()) {
            trashes.forEach(this::logDeletedTrash);
        }
    }

    private void logDeletedTrash(SpaceContentEntityObject trash) {
        if (log.isDebugEnabled()) {
            log.debug("trash deleted: with trash id {}, space key {}", (Object)trash.getId(), (Object)trash.getSpaceKey());
        }
    }
}

