/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.retention.manager;

import com.atlassian.confluence.api.model.retention.SpaceRetentionPolicy;
import com.atlassian.confluence.cache.CoreCache;
import com.atlassian.confluence.impl.cache.tx.TransactionAwareCache;
import com.atlassian.confluence.impl.cache.tx.TransactionAwareCacheFactory;
import com.atlassian.confluence.retention.SpaceRetentionPolicyManager;
import java.util.Optional;

public class CachingSpaceRetentionPolicyManager
implements SpaceRetentionPolicyManager {
    private final SpaceRetentionPolicyManager delegate;
    private final TransactionAwareCache<String, Optional<SpaceRetentionPolicy>> spaceKeyToPolicyCache;

    public CachingSpaceRetentionPolicyManager(SpaceRetentionPolicyManager delegate, TransactionAwareCacheFactory cacheFactory) {
        this.delegate = delegate;
        this.spaceKeyToPolicyCache = (TransactionAwareCache)CoreCache.SPACE_RETENTION_POLICY_BY_SPACE_KEY.resolve(arg_0 -> ((TransactionAwareCacheFactory)cacheFactory).getTxCache(arg_0));
    }

    public void deletePolicy(String spaceKey) {
        this.delegate.deletePolicy(spaceKey);
        this.spaceKeyToPolicyCache.remove((Object)spaceKey);
    }

    public void savePolicy(String spaceKey, SpaceRetentionPolicy newPolicy) {
        this.delegate.savePolicy(spaceKey, newPolicy);
        this.spaceKeyToPolicyCache.remove((Object)spaceKey);
    }

    public Optional<SpaceRetentionPolicy> getPolicy(String spaceKey) {
        return (Optional)this.spaceKeyToPolicyCache.get((Object)spaceKey, () -> this.delegate.getPolicy(spaceKey));
    }

    public Optional<SpaceRetentionPolicy> getPolicy(long spaceId) {
        return this.delegate.getPolicy(spaceId);
    }
}

