/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.retention.manager;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.api.model.retention.GlobalRetentionPolicy;
import com.atlassian.confluence.event.events.retention.GlobalRetentionPolicyChangedEvent;
import com.atlassian.confluence.impl.retention.manager.GlobalRetentionPolicyManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.DefaultObjectMapperProvider;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGlobalRetentionPolicyManager
implements GlobalRetentionPolicyManager {
    static final String GLOBAL_RETENTION_POLICY_KEY = "com.atlassian.confluence.impl.content.retentionrules:global-retention-policy";
    private static final Logger logger = LoggerFactory.getLogger(DefaultGlobalRetentionPolicyManager.class);
    private static final GlobalRetentionPolicy DEFAULT_POLICY = new GlobalRetentionPolicy();
    private final PluginSettingsFactory pluginSettingsFactory;
    private final EventPublisher eventPublisher;
    private final ObjectMapper objectMapper;

    public DefaultGlobalRetentionPolicyManager(PluginSettingsFactory pluginSettingsFactory, EventPublisher eventPublisher) {
        this(pluginSettingsFactory, eventPublisher, new DefaultObjectMapperProvider().getObjectMapper());
    }

    @VisibleForTesting
    DefaultGlobalRetentionPolicyManager(PluginSettingsFactory pluginSettingsFactory, EventPublisher eventPublisher, ObjectMapper objectMapper) {
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.eventPublisher = eventPublisher;
        this.objectMapper = objectMapper;
    }

    @Override
    public GlobalRetentionPolicy getPolicy() {
        Object policy = this.pluginSettingsFactory.createGlobalSettings().get(GLOBAL_RETENTION_POLICY_KEY);
        logger.debug("Existing GlobalRetentionPolicy is: {}", policy);
        if (policy != null) {
            try {
                return (GlobalRetentionPolicy)this.objectMapper.readValue((String)policy, GlobalRetentionPolicy.class);
            }
            catch (IOException e) {
                logger.error("Error parsing GlobalRetentionPolicy: {}", policy, (Object)e);
            }
        }
        logger.debug("Returning default GlobalRetentionPolicy");
        return DEFAULT_POLICY;
    }

    @Override
    public void savePolicy(GlobalRetentionPolicy newPolicy) {
        newPolicy.setLastModifiedBy(this.getAuthenticatedUserKey());
        try {
            GlobalRetentionPolicy oldPolicy = this.getPolicy();
            this.pluginSettingsFactory.createGlobalSettings().put(GLOBAL_RETENTION_POLICY_KEY, (Object)this.objectMapper.writeValueAsString((Object)newPolicy));
            this.auditChange(oldPolicy, newPolicy);
        }
        catch (IOException e) {
            logger.error("Error persisting global retention policy: {}", (Object)newPolicy, (Object)e);
        }
    }

    private void auditChange(GlobalRetentionPolicy oldPolicy, GlobalRetentionPolicy newPolicy) {
        this.eventPublisher.publish((Object)new GlobalRetentionPolicyChangedEvent(oldPolicy, newPolicy));
    }

    private String getAuthenticatedUserKey() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        return user.getKey().getStringValue();
    }
}

