/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.retention.manager;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.JsonString;
import com.atlassian.confluence.api.model.content.JsonSpaceProperty;
import com.atlassian.confluence.api.model.content.Version;
import com.atlassian.confluence.api.model.reference.Reference;
import com.atlassian.confluence.api.model.retention.SpaceRetentionPolicy;
import com.atlassian.confluence.api.service.content.SpacePropertyService;
import com.atlassian.confluence.api.service.exceptions.InternalServerException;
import com.atlassian.confluence.api.service.exceptions.NotFoundException;
import com.atlassian.confluence.dmz.spaces.SpaceManagerInternal;
import com.atlassian.confluence.event.events.retention.SpaceRetentionPolicyChangedEvent;
import com.atlassian.confluence.event.events.retention.SpaceRetentionPolicyCreatedEvent;
import com.atlassian.confluence.event.events.retention.SpaceRetentionPolicyDeletedEvent;
import com.atlassian.confluence.rest.serialization.jackson2.CustomSerializerModuleFactory;
import com.atlassian.confluence.rest.v2.api.model.ExpansionsParser;
import com.atlassian.confluence.retention.SpacePropertyServiceProvider;
import com.atlassian.confluence.retention.SpaceRetentionPolicyManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.event.api.EventPublisher;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSpaceRetentionPolicyManager
implements SpaceRetentionPolicyManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSpaceRetentionPolicyManager.class);
    private static final String FAILED_TO_PARSE_SPACE_RETENTION_POLICY = "Failed to parse SpaceRetentionPolicy";
    private static final String PROPERTY_EXPANSIONS = "space,version";
    private final SpaceManagerInternal spaceManager;
    private final SpacePropertyServiceProvider spacePropertyServiceProvider;
    private final PermissionManager permissionManager;
    private final EventPublisher eventPublisher;
    private final ObjectMapper objectMapper;

    public DefaultSpaceRetentionPolicyManager(SpaceManagerInternal spaceManager, SpacePropertyServiceProvider spacePropertyServiceProvider, PermissionManager permissionManager, EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
        this.spaceManager = spaceManager;
        this.spacePropertyServiceProvider = spacePropertyServiceProvider;
        this.permissionManager = permissionManager;
        this.objectMapper = CustomSerializerModuleFactory.createObjectMapper();
    }

    public Optional<SpaceRetentionPolicy> getPolicy(String spaceKey) {
        Optional<JsonSpaceProperty> spaceProperty = this.getSpaceRetentionPolicyProperty(spaceKey);
        if (spaceProperty.isPresent()) {
            return Optional.ofNullable(this.parseSpaceProperty(spaceProperty.get()));
        }
        logger.debug("No SpaceRetentionPolicies found for space with key {}", (Object)spaceKey);
        return Optional.empty();
    }

    public Optional<SpaceRetentionPolicy> getPolicy(long spaceId) {
        return Optional.ofNullable(this.spaceManager.getSpace(spaceId)).flatMap(space -> this.getPolicy(space.getKey()));
    }

    public void deletePolicy(String spaceKey) {
        Optional<JsonSpaceProperty> existingProperty = this.getSpaceRetentionPolicyProperty(spaceKey);
        if (!existingProperty.isPresent()) {
            throw new NotFoundException("Space not found: " + spaceKey);
        }
        this.getSpacePropertyService().delete(existingProperty.get());
        SpaceRetentionPolicy oldPolicy = this.parseSpaceProperty(existingProperty.get());
        Space space = this.getSpace(spaceKey);
        this.eventPublisher.publish((Object)new SpaceRetentionPolicyDeletedEvent(oldPolicy, space));
    }

    public void savePolicy(String spaceKey, SpaceRetentionPolicy newPolicy) {
        Space space = this.getSpace(spaceKey);
        if (space != null) {
            newPolicy.setLastModifiedBy(this.getAuthenticatedUserKey());
            Optional<JsonSpaceProperty> existingProperty = this.getSpaceRetentionPolicyProperty(spaceKey);
            if (existingProperty.isEmpty()) {
                this.createPolicy(spaceKey, newPolicy);
                this.eventPublisher.publish((Object)new SpaceRetentionPolicyCreatedEvent(newPolicy, space));
            } else {
                this.updatePolicy(spaceKey, newPolicy, this.parseSpacePropertyVersion(existingProperty.get()));
                SpaceRetentionPolicy oldPolicy = this.parseSpaceProperty(existingProperty.get());
                this.eventPublisher.publish((Object)new SpaceRetentionPolicyChangedEvent(oldPolicy, newPolicy, space));
            }
        } else {
            throw new NotFoundException("Space not found: " + spaceKey);
        }
    }

    private void updatePolicy(String spaceKey, SpaceRetentionPolicy newPolicy, int nextVersionNumber) {
        JsonSpaceProperty newSpaceProperty = this.createSpaceRetentionExemptionProperty(spaceKey, newPolicy, nextVersionNumber).build();
        this.getSpacePropertyService().update(newSpaceProperty);
    }

    private void createPolicy(String spaceKey, SpaceRetentionPolicy newPolicy) {
        JsonSpaceProperty newSpaceProperty = this.createSpaceRetentionExemptionProperty(spaceKey, newPolicy, 1).build();
        this.getSpacePropertyService().create(newSpaceProperty);
    }

    protected SpacePropertyService getSpacePropertyService() {
        return this.spacePropertyServiceProvider.get();
    }

    private Space getSpace(String spaceKey) {
        return this.spaceManager.getSpace(spaceKey);
    }

    private JsonSpaceProperty.SpacePropertyBuilder createSpaceRetentionExemptionProperty(String spaceKey, SpaceRetentionPolicy newPolicy, int versionNumber) {
        return (JsonSpaceProperty.SpacePropertyBuilder)((JsonSpaceProperty.SpacePropertyBuilder)((JsonSpaceProperty.SpacePropertyBuilder)JsonSpaceProperty.builder().space(Reference.to((Object)com.atlassian.confluence.api.model.content.Space.builder().key(spaceKey).build())).key("com.atlassian.confluence.impl.content.retentionrules:space-retention-policy")).version(Reference.to((Object)Version.builder().number(versionNumber).build()))).value(new JsonString(this.toJsonNode(newPolicy).toString()));
    }

    JsonNode toJsonNode(SpaceRetentionPolicy newPolicy) {
        ObjectNode policyAsTree = (ObjectNode)this.objectMapper.valueToTree((Object)newPolicy);
        policyAsTree.put("lastModifiedDate", newPolicy.getLastModifiedAt().toInstant().toEpochMilli());
        return policyAsTree;
    }

    private Optional<JsonSpaceProperty> getSpaceRetentionPolicyProperty(String spaceKey) {
        AtomicReference property = new AtomicReference();
        this.permissionManager.withExemption(() -> {
            Expansion[] expansions = ExpansionsParser.parse((String)PROPERTY_EXPANSIONS);
            property.set((JsonSpaceProperty)this.getSpacePropertyService().find(expansions).withSpaceKey(spaceKey).withPropertyKey("com.atlassian.confluence.impl.content.retentionrules:space-retention-policy").fetchOrNull());
        });
        return Optional.ofNullable((JsonSpaceProperty)property.get());
    }

    private String getAuthenticatedUserKey() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        return user.getKey().getStringValue();
    }

    private SpaceRetentionPolicy parseSpaceProperty(JsonSpaceProperty property) {
        try {
            JsonString propertyValue = property.getValue();
            if (propertyValue == null) {
                return null;
            }
            String rawValue = propertyValue.getValue();
            if (rawValue != null) {
                SpaceRetentionPolicy policy = (SpaceRetentionPolicy)this.objectMapper.readValue(rawValue, SpaceRetentionPolicy.class);
                OffsetDateTime lastModified = this.parseLastSpaceRetentionPropertyModifiedDate(property);
                if (lastModified != null) {
                    policy.setLastModifiedAt(lastModified);
                }
                return policy;
            }
        }
        catch (IOException e) {
            logger.error("Error parsing SpaceRetentionPolicy from JsonSpaceProperty");
            throw new InternalServerException(FAILED_TO_PARSE_SPACE_RETENTION_POLICY, (Throwable)e);
        }
        return null;
    }

    private int parseSpacePropertyVersion(JsonSpaceProperty property) {
        Version versionInfo = property.getVersion();
        if (versionInfo != null) {
            return versionInfo.getNumber() + 1;
        }
        return 1;
    }

    private OffsetDateTime parseLastSpaceRetentionPropertyModifiedDate(JsonSpaceProperty property) {
        Version version = property.getVersion();
        if (version != null) {
            return version.getWhenAt();
        }
        return null;
    }
}

